/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NotebookInstanceStatus {
    PENDING("Pending"),
    IN_SERVICE("InService"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    FAILED("Failed"),
    DELETING("Deleting"),
    UPDATING("Updating"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NotebookInstanceStatus> VALUE_MAP;
    private final String value;

    private NotebookInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NotebookInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NotebookInstanceStatus> knownValues() {
        EnumSet<NotebookInstanceStatus> knownValues = EnumSet.allOf(NotebookInstanceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NotebookInstanceStatus.class, NotebookInstanceStatus::toString);
    }
}

