/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DataCatalogConfig;
import software.amazon.awssdk.services.sagemaker.model.S3StorageConfig;
import software.amazon.awssdk.services.sagemaker.model.TableFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OfflineStoreConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OfflineStoreConfig> {
    private static final SdkField<S3StorageConfig> S3_STORAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3StorageConfig").getter(OfflineStoreConfig.getter(OfflineStoreConfig::s3StorageConfig)).setter(OfflineStoreConfig.setter(Builder::s3StorageConfig)).constructor(S3StorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageConfig").build()}).build();
    private static final SdkField<Boolean> DISABLE_GLUE_TABLE_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableGlueTableCreation").getter(OfflineStoreConfig.getter(OfflineStoreConfig::disableGlueTableCreation)).setter(OfflineStoreConfig.setter(Builder::disableGlueTableCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableGlueTableCreation").build()}).build();
    private static final SdkField<DataCatalogConfig> DATA_CATALOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCatalogConfig").getter(OfflineStoreConfig.getter(OfflineStoreConfig::dataCatalogConfig)).setter(OfflineStoreConfig.setter(Builder::dataCatalogConfig)).constructor(DataCatalogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogConfig").build()}).build();
    private static final SdkField<String> TABLE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableFormat").getter(OfflineStoreConfig.getter(OfflineStoreConfig::tableFormatAsString)).setter(OfflineStoreConfig.setter(Builder::tableFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_STORAGE_CONFIG_FIELD, DISABLE_GLUE_TABLE_CREATION_FIELD, DATA_CATALOG_CONFIG_FIELD, TABLE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OfflineStoreConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3StorageConfig s3StorageConfig;
    private final Boolean disableGlueTableCreation;
    private final DataCatalogConfig dataCatalogConfig;
    private final String tableFormat;

    private OfflineStoreConfig(BuilderImpl builder) {
        this.s3StorageConfig = builder.s3StorageConfig;
        this.disableGlueTableCreation = builder.disableGlueTableCreation;
        this.dataCatalogConfig = builder.dataCatalogConfig;
        this.tableFormat = builder.tableFormat;
    }

    public final S3StorageConfig s3StorageConfig() {
        return this.s3StorageConfig;
    }

    public final Boolean disableGlueTableCreation() {
        return this.disableGlueTableCreation;
    }

    public final DataCatalogConfig dataCatalogConfig() {
        return this.dataCatalogConfig;
    }

    public final TableFormat tableFormat() {
        return TableFormat.fromValue(this.tableFormat);
    }

    public final String tableFormatAsString() {
        return this.tableFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableGlueTableCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCatalogConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflineStoreConfig)) {
            return false;
        }
        OfflineStoreConfig other = (OfflineStoreConfig)obj;
        return Objects.equals(this.s3StorageConfig(), other.s3StorageConfig()) && Objects.equals(this.disableGlueTableCreation(), other.disableGlueTableCreation()) && Objects.equals(this.dataCatalogConfig(), other.dataCatalogConfig()) && Objects.equals(this.tableFormatAsString(), other.tableFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OfflineStoreConfig").add("S3StorageConfig", (Object)this.s3StorageConfig()).add("DisableGlueTableCreation", (Object)this.disableGlueTableCreation()).add("DataCatalogConfig", (Object)this.dataCatalogConfig()).add("TableFormat", (Object)this.tableFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3StorageConfig": {
                return Optional.ofNullable(clazz.cast(this.s3StorageConfig()));
            }
            case "DisableGlueTableCreation": {
                return Optional.ofNullable(clazz.cast(this.disableGlueTableCreation()));
            }
            case "DataCatalogConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCatalogConfig()));
            }
            case "TableFormat": {
                return Optional.ofNullable(clazz.cast(this.tableFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3StorageConfig", S3_STORAGE_CONFIG_FIELD);
        map.put("DisableGlueTableCreation", DISABLE_GLUE_TABLE_CREATION_FIELD);
        map.put("DataCatalogConfig", DATA_CATALOG_CONFIG_FIELD);
        map.put("TableFormat", TABLE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OfflineStoreConfig, T> g) {
        return obj -> g.apply((OfflineStoreConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3StorageConfig s3StorageConfig;
        private Boolean disableGlueTableCreation;
        private DataCatalogConfig dataCatalogConfig;
        private String tableFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(OfflineStoreConfig model) {
            this.s3StorageConfig(model.s3StorageConfig);
            this.disableGlueTableCreation(model.disableGlueTableCreation);
            this.dataCatalogConfig(model.dataCatalogConfig);
            this.tableFormat(model.tableFormat);
        }

        public final S3StorageConfig.Builder getS3StorageConfig() {
            return this.s3StorageConfig != null ? this.s3StorageConfig.toBuilder() : null;
        }

        public final void setS3StorageConfig(S3StorageConfig.BuilderImpl s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig != null ? s3StorageConfig.build() : null;
        }

        @Override
        public final Builder s3StorageConfig(S3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public final Boolean getDisableGlueTableCreation() {
            return this.disableGlueTableCreation;
        }

        public final void setDisableGlueTableCreation(Boolean disableGlueTableCreation) {
            this.disableGlueTableCreation = disableGlueTableCreation;
        }

        @Override
        public final Builder disableGlueTableCreation(Boolean disableGlueTableCreation) {
            this.disableGlueTableCreation = disableGlueTableCreation;
            return this;
        }

        public final DataCatalogConfig.Builder getDataCatalogConfig() {
            return this.dataCatalogConfig != null ? this.dataCatalogConfig.toBuilder() : null;
        }

        public final void setDataCatalogConfig(DataCatalogConfig.BuilderImpl dataCatalogConfig) {
            this.dataCatalogConfig = dataCatalogConfig != null ? dataCatalogConfig.build() : null;
        }

        @Override
        public final Builder dataCatalogConfig(DataCatalogConfig dataCatalogConfig) {
            this.dataCatalogConfig = dataCatalogConfig;
            return this;
        }

        public final String getTableFormat() {
            return this.tableFormat;
        }

        public final void setTableFormat(String tableFormat) {
            this.tableFormat = tableFormat;
        }

        @Override
        public final Builder tableFormat(String tableFormat) {
            this.tableFormat = tableFormat;
            return this;
        }

        @Override
        public final Builder tableFormat(TableFormat tableFormat) {
            this.tableFormat(tableFormat == null ? null : tableFormat.toString());
            return this;
        }

        public OfflineStoreConfig build() {
            return new OfflineStoreConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OfflineStoreConfig> {
        public Builder s3StorageConfig(S3StorageConfig var1);

        default public Builder s3StorageConfig(Consumer<S3StorageConfig.Builder> s3StorageConfig) {
            return this.s3StorageConfig((S3StorageConfig)((S3StorageConfig.Builder)S3StorageConfig.builder().applyMutation(s3StorageConfig)).build());
        }

        public Builder disableGlueTableCreation(Boolean var1);

        public Builder dataCatalogConfig(DataCatalogConfig var1);

        default public Builder dataCatalogConfig(Consumer<DataCatalogConfig.Builder> dataCatalogConfig) {
            return this.dataCatalogConfig((DataCatalogConfig)((DataCatalogConfig.Builder)DataCatalogConfig.builder().applyMutation(dataCatalogConfig)).build());
        }

        public Builder tableFormat(String var1);

        public Builder tableFormat(TableFormat var1);
    }
}

