/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OptimizationSageMakerModel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizationJobOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptimizationJobOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(OptimizationJobOutputConfig.getter(OptimizationJobOutputConfig::kmsKeyId)).setter(OptimizationJobOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputLocation").getter(OptimizationJobOutputConfig.getter(OptimizationJobOutputConfig::s3OutputLocation)).setter(OptimizationJobOutputConfig.setter(Builder::s3OutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()}).build();
    private static final SdkField<OptimizationSageMakerModel> SAGE_MAKER_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SageMakerModel").getter(OptimizationJobOutputConfig.getter(OptimizationJobOutputConfig::sageMakerModel)).setter(OptimizationJobOutputConfig.setter(Builder::sageMakerModel)).constructor(OptimizationSageMakerModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, S3_OUTPUT_LOCATION_FIELD, SAGE_MAKER_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizationJobOutputConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String s3OutputLocation;
    private final OptimizationSageMakerModel sageMakerModel;

    private OptimizationJobOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3OutputLocation = builder.s3OutputLocation;
        this.sageMakerModel = builder.sageMakerModel;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String s3OutputLocation() {
        return this.s3OutputLocation;
    }

    public final OptimizationSageMakerModel sageMakerModel() {
        return this.sageMakerModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerModel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizationJobOutputConfig)) {
            return false;
        }
        OptimizationJobOutputConfig other = (OptimizationJobOutputConfig)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(this.sageMakerModel(), other.sageMakerModel());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizationJobOutputConfig").add("KmsKeyId", (Object)this.kmsKeyId()).add("S3OutputLocation", (Object)this.s3OutputLocation()).add("SageMakerModel", (Object)this.sageMakerModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "S3OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.s3OutputLocation()));
            }
            case "SageMakerModel": {
                return Optional.ofNullable(clazz.cast(this.sageMakerModel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("S3OutputLocation", S3_OUTPUT_LOCATION_FIELD);
        map.put("SageMakerModel", SAGE_MAKER_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizationJobOutputConfig, T> g) {
        return obj -> g.apply((OptimizationJobOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String s3OutputLocation;
        private OptimizationSageMakerModel sageMakerModel;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizationJobOutputConfig model) {
            this.kmsKeyId(model.kmsKeyId);
            this.s3OutputLocation(model.s3OutputLocation);
            this.sageMakerModel(model.sageMakerModel);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3OutputLocation() {
            return this.s3OutputLocation;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final OptimizationSageMakerModel.Builder getSageMakerModel() {
            return this.sageMakerModel != null ? this.sageMakerModel.toBuilder() : null;
        }

        public final void setSageMakerModel(OptimizationSageMakerModel.BuilderImpl sageMakerModel) {
            this.sageMakerModel = sageMakerModel != null ? sageMakerModel.build() : null;
        }

        @Override
        public final Builder sageMakerModel(OptimizationSageMakerModel sageMakerModel) {
            this.sageMakerModel = sageMakerModel;
            return this;
        }

        public OptimizationJobOutputConfig build() {
            return new OptimizationJobOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptimizationJobOutputConfig> {
        public Builder kmsKeyId(String var1);

        public Builder s3OutputLocation(String var1);

        public Builder sageMakerModel(OptimizationSageMakerModel var1);

        default public Builder sageMakerModel(Consumer<OptimizationSageMakerModel.Builder> sageMakerModel) {
            return this.sageMakerModel((OptimizationSageMakerModel)((OptimizationSageMakerModel.Builder)OptimizationSageMakerModel.builder().applyMutation(sageMakerModel)).build());
        }
    }
}

