/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CustomizationTechnique;
import software.amazon.awssdk.services.sagemaker.model.EvaluationType;
import software.amazon.awssdk.services.sagemaker.model.Peft;
import software.amazon.awssdk.services.sagemaker.model.ServerlessJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServerlessJobConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServerlessJobConfig> {
    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseModelArn").getter(ServerlessJobConfig.getter(ServerlessJobConfig::baseModelArn)).setter(ServerlessJobConfig.setter(Builder::baseModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseModelArn").build()}).build();
    private static final SdkField<Boolean> ACCEPT_EULA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptEula").getter(ServerlessJobConfig.getter(ServerlessJobConfig::acceptEula)).setter(ServerlessJobConfig.setter(Builder::acceptEula)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptEula").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(ServerlessJobConfig.getter(ServerlessJobConfig::jobTypeAsString)).setter(ServerlessJobConfig.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> CUSTOMIZATION_TECHNIQUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomizationTechnique").getter(ServerlessJobConfig.getter(ServerlessJobConfig::customizationTechniqueAsString)).setter(ServerlessJobConfig.setter(Builder::customizationTechnique)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomizationTechnique").build()}).build();
    private static final SdkField<String> PEFT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Peft").getter(ServerlessJobConfig.getter(ServerlessJobConfig::peftAsString)).setter(ServerlessJobConfig.setter(Builder::peft)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Peft").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(ServerlessJobConfig.getter(ServerlessJobConfig::evaluationTypeAsString)).setter(ServerlessJobConfig.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluatorArn").getter(ServerlessJobConfig.getter(ServerlessJobConfig::evaluatorArn)).setter(ServerlessJobConfig.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_MODEL_ARN_FIELD, ACCEPT_EULA_FIELD, JOB_TYPE_FIELD, CUSTOMIZATION_TECHNIQUE_FIELD, PEFT_FIELD, EVALUATION_TYPE_FIELD, EVALUATOR_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServerlessJobConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String baseModelArn;
    private final Boolean acceptEula;
    private final String jobType;
    private final String customizationTechnique;
    private final String peft;
    private final String evaluationType;
    private final String evaluatorArn;

    private ServerlessJobConfig(BuilderImpl builder) {
        this.baseModelArn = builder.baseModelArn;
        this.acceptEula = builder.acceptEula;
        this.jobType = builder.jobType;
        this.customizationTechnique = builder.customizationTechnique;
        this.peft = builder.peft;
        this.evaluationType = builder.evaluationType;
        this.evaluatorArn = builder.evaluatorArn;
    }

    public final String baseModelArn() {
        return this.baseModelArn;
    }

    public final Boolean acceptEula() {
        return this.acceptEula;
    }

    public final ServerlessJobType jobType() {
        return ServerlessJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final CustomizationTechnique customizationTechnique() {
        return CustomizationTechnique.fromValue(this.customizationTechnique);
    }

    public final String customizationTechniqueAsString() {
        return this.customizationTechnique;
    }

    public final Peft peft() {
        return Peft.fromValue(this.peft);
    }

    public final String peftAsString() {
        return this.peft;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptEula());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizationTechniqueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.peftAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessJobConfig)) {
            return false;
        }
        ServerlessJobConfig other = (ServerlessJobConfig)obj;
        return Objects.equals(this.baseModelArn(), other.baseModelArn()) && Objects.equals(this.acceptEula(), other.acceptEula()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.customizationTechniqueAsString(), other.customizationTechniqueAsString()) && Objects.equals(this.peftAsString(), other.peftAsString()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.evaluatorArn(), other.evaluatorArn());
    }

    public final String toString() {
        return ToString.builder((String)"ServerlessJobConfig").add("BaseModelArn", (Object)this.baseModelArn()).add("AcceptEula", (Object)this.acceptEula()).add("JobType", (Object)this.jobTypeAsString()).add("CustomizationTechnique", (Object)this.customizationTechniqueAsString()).add("Peft", (Object)this.peftAsString()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("EvaluatorArn", (Object)this.evaluatorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseModelArn": {
                return Optional.ofNullable(clazz.cast(this.baseModelArn()));
            }
            case "AcceptEula": {
                return Optional.ofNullable(clazz.cast(this.acceptEula()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "CustomizationTechnique": {
                return Optional.ofNullable(clazz.cast(this.customizationTechniqueAsString()));
            }
            case "Peft": {
                return Optional.ofNullable(clazz.cast(this.peftAsString()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "EvaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BaseModelArn", BASE_MODEL_ARN_FIELD);
        map.put("AcceptEula", ACCEPT_EULA_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("CustomizationTechnique", CUSTOMIZATION_TECHNIQUE_FIELD);
        map.put("Peft", PEFT_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessJobConfig, T> g) {
        return obj -> g.apply((ServerlessJobConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseModelArn;
        private Boolean acceptEula;
        private String jobType;
        private String customizationTechnique;
        private String peft;
        private String evaluationType;
        private String evaluatorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessJobConfig model) {
            this.baseModelArn(model.baseModelArn);
            this.acceptEula(model.acceptEula);
            this.jobType(model.jobType);
            this.customizationTechnique(model.customizationTechnique);
            this.peft(model.peft);
            this.evaluationType(model.evaluationType);
            this.evaluatorArn(model.evaluatorArn);
        }

        public final String getBaseModelArn() {
            return this.baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final Boolean getAcceptEula() {
            return this.acceptEula;
        }

        public final void setAcceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
        }

        @Override
        public final Builder acceptEula(Boolean acceptEula) {
            this.acceptEula = acceptEula;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(ServerlessJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getCustomizationTechnique() {
            return this.customizationTechnique;
        }

        public final void setCustomizationTechnique(String customizationTechnique) {
            this.customizationTechnique = customizationTechnique;
        }

        @Override
        public final Builder customizationTechnique(String customizationTechnique) {
            this.customizationTechnique = customizationTechnique;
            return this;
        }

        @Override
        public final Builder customizationTechnique(CustomizationTechnique customizationTechnique) {
            this.customizationTechnique(customizationTechnique == null ? null : customizationTechnique.toString());
            return this;
        }

        public final String getPeft() {
            return this.peft;
        }

        public final void setPeft(String peft) {
            this.peft = peft;
        }

        @Override
        public final Builder peft(String peft) {
            this.peft = peft;
            return this;
        }

        @Override
        public final Builder peft(Peft peft) {
            this.peft(peft == null ? null : peft.toString());
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public ServerlessJobConfig build() {
            return new ServerlessJobConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServerlessJobConfig> {
        public Builder baseModelArn(String var1);

        public Builder acceptEula(Boolean var1);

        public Builder jobType(String var1);

        public Builder jobType(ServerlessJobType var1);

        public Builder customizationTechnique(String var1);

        public Builder customizationTechnique(CustomizationTechnique var1);

        public Builder peft(String var1);

        public Builder peft(Peft var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder evaluatorArn(String var1);
    }
}

