/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FeatureStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnifiedStudioSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UnifiedStudioSettings> {
    private static final SdkField<String> STUDIO_WEB_PORTAL_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StudioWebPortalAccess").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::studioWebPortalAccessAsString)).setter(UnifiedStudioSettings.setter(Builder::studioWebPortalAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioWebPortalAccess").build()}).build();
    private static final SdkField<String> DOMAIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainAccountId").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::domainAccountId)).setter(UnifiedStudioSettings.setter(Builder::domainAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainAccountId").build()}).build();
    private static final SdkField<String> DOMAIN_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainRegion").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::domainRegion)).setter(UnifiedStudioSettings.setter(Builder::domainRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainRegion").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::domainId)).setter(UnifiedStudioSettings.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectId").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::projectId)).setter(UnifiedStudioSettings.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::environmentId)).setter(UnifiedStudioSettings.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<String> PROJECT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectS3Path").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::projectS3Path)).setter(UnifiedStudioSettings.setter(Builder::projectS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectS3Path").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnApplicationArn").getter(UnifiedStudioSettings.getter(UnifiedStudioSettings::singleSignOnApplicationArn)).setter(UnifiedStudioSettings.setter(Builder::singleSignOnApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnApplicationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_WEB_PORTAL_ACCESS_FIELD, DOMAIN_ACCOUNT_ID_FIELD, DOMAIN_REGION_FIELD, DOMAIN_ID_FIELD, PROJECT_ID_FIELD, ENVIRONMENT_ID_FIELD, PROJECT_S3_PATH_FIELD, SINGLE_SIGN_ON_APPLICATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UnifiedStudioSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String studioWebPortalAccess;
    private final String domainAccountId;
    private final String domainRegion;
    private final String domainId;
    private final String projectId;
    private final String environmentId;
    private final String projectS3Path;
    private final String singleSignOnApplicationArn;

    private UnifiedStudioSettings(BuilderImpl builder) {
        this.studioWebPortalAccess = builder.studioWebPortalAccess;
        this.domainAccountId = builder.domainAccountId;
        this.domainRegion = builder.domainRegion;
        this.domainId = builder.domainId;
        this.projectId = builder.projectId;
        this.environmentId = builder.environmentId;
        this.projectS3Path = builder.projectS3Path;
        this.singleSignOnApplicationArn = builder.singleSignOnApplicationArn;
    }

    public final FeatureStatus studioWebPortalAccess() {
        return FeatureStatus.fromValue(this.studioWebPortalAccess);
    }

    public final String studioWebPortalAccessAsString() {
        return this.studioWebPortalAccess;
    }

    public final String domainAccountId() {
        return this.domainAccountId;
    }

    public final String domainRegion() {
        return this.domainRegion;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String projectS3Path() {
        return this.projectS3Path;
    }

    public final String singleSignOnApplicationArn() {
        return this.singleSignOnApplicationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.studioWebPortalAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnApplicationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnifiedStudioSettings)) {
            return false;
        }
        UnifiedStudioSettings other = (UnifiedStudioSettings)obj;
        return Objects.equals(this.studioWebPortalAccessAsString(), other.studioWebPortalAccessAsString()) && Objects.equals(this.domainAccountId(), other.domainAccountId()) && Objects.equals(this.domainRegion(), other.domainRegion()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.projectS3Path(), other.projectS3Path()) && Objects.equals(this.singleSignOnApplicationArn(), other.singleSignOnApplicationArn());
    }

    public final String toString() {
        return ToString.builder((String)"UnifiedStudioSettings").add("StudioWebPortalAccess", (Object)this.studioWebPortalAccessAsString()).add("DomainAccountId", (Object)this.domainAccountId()).add("DomainRegion", (Object)this.domainRegion()).add("DomainId", (Object)this.domainId()).add("ProjectId", (Object)this.projectId()).add("EnvironmentId", (Object)this.environmentId()).add("ProjectS3Path", (Object)this.projectS3Path()).add("SingleSignOnApplicationArn", (Object)this.singleSignOnApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StudioWebPortalAccess": {
                return Optional.ofNullable(clazz.cast(this.studioWebPortalAccessAsString()));
            }
            case "DomainAccountId": {
                return Optional.ofNullable(clazz.cast(this.domainAccountId()));
            }
            case "DomainRegion": {
                return Optional.ofNullable(clazz.cast(this.domainRegion()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "ProjectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "ProjectS3Path": {
                return Optional.ofNullable(clazz.cast(this.projectS3Path()));
            }
            case "SingleSignOnApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnApplicationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StudioWebPortalAccess", STUDIO_WEB_PORTAL_ACCESS_FIELD);
        map.put("DomainAccountId", DOMAIN_ACCOUNT_ID_FIELD);
        map.put("DomainRegion", DOMAIN_REGION_FIELD);
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("ProjectId", PROJECT_ID_FIELD);
        map.put("EnvironmentId", ENVIRONMENT_ID_FIELD);
        map.put("ProjectS3Path", PROJECT_S3_PATH_FIELD);
        map.put("SingleSignOnApplicationArn", SINGLE_SIGN_ON_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnifiedStudioSettings, T> g) {
        return obj -> g.apply((UnifiedStudioSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String studioWebPortalAccess;
        private String domainAccountId;
        private String domainRegion;
        private String domainId;
        private String projectId;
        private String environmentId;
        private String projectS3Path;
        private String singleSignOnApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UnifiedStudioSettings model) {
            this.studioWebPortalAccess(model.studioWebPortalAccess);
            this.domainAccountId(model.domainAccountId);
            this.domainRegion(model.domainRegion);
            this.domainId(model.domainId);
            this.projectId(model.projectId);
            this.environmentId(model.environmentId);
            this.projectS3Path(model.projectS3Path);
            this.singleSignOnApplicationArn(model.singleSignOnApplicationArn);
        }

        public final String getStudioWebPortalAccess() {
            return this.studioWebPortalAccess;
        }

        public final void setStudioWebPortalAccess(String studioWebPortalAccess) {
            this.studioWebPortalAccess = studioWebPortalAccess;
        }

        @Override
        public final Builder studioWebPortalAccess(String studioWebPortalAccess) {
            this.studioWebPortalAccess = studioWebPortalAccess;
            return this;
        }

        @Override
        public final Builder studioWebPortalAccess(FeatureStatus studioWebPortalAccess) {
            this.studioWebPortalAccess(studioWebPortalAccess == null ? null : studioWebPortalAccess.toString());
            return this;
        }

        public final String getDomainAccountId() {
            return this.domainAccountId;
        }

        public final void setDomainAccountId(String domainAccountId) {
            this.domainAccountId = domainAccountId;
        }

        @Override
        public final Builder domainAccountId(String domainAccountId) {
            this.domainAccountId = domainAccountId;
            return this;
        }

        public final String getDomainRegion() {
            return this.domainRegion;
        }

        public final void setDomainRegion(String domainRegion) {
            this.domainRegion = domainRegion;
        }

        @Override
        public final Builder domainRegion(String domainRegion) {
            this.domainRegion = domainRegion;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getProjectS3Path() {
            return this.projectS3Path;
        }

        public final void setProjectS3Path(String projectS3Path) {
            this.projectS3Path = projectS3Path;
        }

        @Override
        public final Builder projectS3Path(String projectS3Path) {
            this.projectS3Path = projectS3Path;
            return this;
        }

        public final String getSingleSignOnApplicationArn() {
            return this.singleSignOnApplicationArn;
        }

        public final void setSingleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
        }

        @Override
        public final Builder singleSignOnApplicationArn(String singleSignOnApplicationArn) {
            this.singleSignOnApplicationArn = singleSignOnApplicationArn;
            return this;
        }

        public UnifiedStudioSettings build() {
            return new UnifiedStudioSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UnifiedStudioSettings> {
        public Builder studioWebPortalAccess(String var1);

        public Builder studioWebPortalAccess(FeatureStatus var1);

        public Builder domainAccountId(String var1);

        public Builder domainRegion(String var1);

        public Builder domainId(String var1);

        public Builder projectId(String var1);

        public Builder environmentId(String var1);

        public Builder projectS3Path(String var1);

        public Builder singleSignOnApplicationArn(String var1);
    }
}

