/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningUpdateDetails;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UpdateTemplateProvider;
import software.amazon.awssdk.services.sagemaker.model.UpdateTemplateProviderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(UpdateProjectRequest.getter(UpdateProjectRequest::projectName)).setter(UpdateProjectRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectDescription").getter(UpdateProjectRequest.getter(UpdateProjectRequest::projectDescription)).setter(UpdateProjectRequest.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build()}).build();
    private static final SdkField<ServiceCatalogProvisioningUpdateDetails> SERVICE_CATALOG_PROVISIONING_UPDATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCatalogProvisioningUpdateDetails").getter(UpdateProjectRequest.getter(UpdateProjectRequest::serviceCatalogProvisioningUpdateDetails)).setter(UpdateProjectRequest.setter(Builder::serviceCatalogProvisioningUpdateDetails)).constructor(ServiceCatalogProvisioningUpdateDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisioningUpdateDetails").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(UpdateProjectRequest.getter(UpdateProjectRequest::tags)).setter(UpdateProjectRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UpdateTemplateProvider>> TEMPLATE_PROVIDERS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplateProvidersToUpdate").getter(UpdateProjectRequest.getter(UpdateProjectRequest::templateProvidersToUpdate)).setter(UpdateProjectRequest.setter(Builder::templateProvidersToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateProvidersToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateTemplateProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, PROJECT_DESCRIPTION_FIELD, SERVICE_CATALOG_PROVISIONING_UPDATE_DETAILS_FIELD, TAGS_FIELD, TEMPLATE_PROVIDERS_TO_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProjectRequest.memberNameToFieldInitializer();
    private final String projectName;
    private final String projectDescription;
    private final ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails;
    private final List<Tag> tags;
    private final List<UpdateTemplateProvider> templateProvidersToUpdate;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.serviceCatalogProvisioningUpdateDetails = builder.serviceCatalogProvisioningUpdateDetails;
        this.tags = builder.tags;
        this.templateProvidersToUpdate = builder.templateProvidersToUpdate;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails() {
        return this.serviceCatalogProvisioningUpdateDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasTemplateProvidersToUpdate() {
        return this.templateProvidersToUpdate != null && !(this.templateProvidersToUpdate instanceof SdkAutoConstructList);
    }

    public final List<UpdateTemplateProvider> templateProvidersToUpdate() {
        return this.templateProvidersToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCatalogProvisioningUpdateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateProvidersToUpdate() ? this.templateProvidersToUpdate() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest)((Object)obj);
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.serviceCatalogProvisioningUpdateDetails(), other.serviceCatalogProvisioningUpdateDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTemplateProvidersToUpdate() == other.hasTemplateProvidersToUpdate() && Objects.equals(this.templateProvidersToUpdate(), other.templateProvidersToUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectRequest").add("ProjectName", (Object)this.projectName()).add("ProjectDescription", (Object)this.projectDescription()).add("ServiceCatalogProvisioningUpdateDetails", (Object)this.serviceCatalogProvisioningUpdateDetails()).add("Tags", this.hasTags() ? this.tags() : null).add("TemplateProvidersToUpdate", this.hasTemplateProvidersToUpdate() ? this.templateProvidersToUpdate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ProjectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "ServiceCatalogProvisioningUpdateDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceCatalogProvisioningUpdateDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TemplateProvidersToUpdate": {
                return Optional.ofNullable(clazz.cast(this.templateProvidersToUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("ProjectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("ServiceCatalogProvisioningUpdateDetails", SERVICE_CATALOG_PROVISIONING_UPDATE_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("TemplateProvidersToUpdate", TEMPLATE_PROVIDERS_TO_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String projectName;
        private String projectDescription;
        private ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<UpdateTemplateProvider> templateProvidersToUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            this.projectName(model.projectName);
            this.projectDescription(model.projectDescription);
            this.serviceCatalogProvisioningUpdateDetails(model.serviceCatalogProvisioningUpdateDetails);
            this.tags(model.tags);
            this.templateProvidersToUpdate(model.templateProvidersToUpdate);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final ServiceCatalogProvisioningUpdateDetails.Builder getServiceCatalogProvisioningUpdateDetails() {
            return this.serviceCatalogProvisioningUpdateDetails != null ? this.serviceCatalogProvisioningUpdateDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisioningUpdateDetails(ServiceCatalogProvisioningUpdateDetails.BuilderImpl serviceCatalogProvisioningUpdateDetails) {
            this.serviceCatalogProvisioningUpdateDetails = serviceCatalogProvisioningUpdateDetails != null ? serviceCatalogProvisioningUpdateDetails.build() : null;
        }

        @Override
        public final Builder serviceCatalogProvisioningUpdateDetails(ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails) {
            this.serviceCatalogProvisioningUpdateDetails = serviceCatalogProvisioningUpdateDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UpdateTemplateProvider.Builder> getTemplateProvidersToUpdate() {
            List<UpdateTemplateProvider.Builder> result = UpdateTemplateProviderListCopier.copyToBuilder(this.templateProvidersToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateProvidersToUpdate(Collection<UpdateTemplateProvider.BuilderImpl> templateProvidersToUpdate) {
            this.templateProvidersToUpdate = UpdateTemplateProviderListCopier.copyFromBuilder(templateProvidersToUpdate);
        }

        @Override
        public final Builder templateProvidersToUpdate(Collection<UpdateTemplateProvider> templateProvidersToUpdate) {
            this.templateProvidersToUpdate = UpdateTemplateProviderListCopier.copy(templateProvidersToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateProvidersToUpdate(UpdateTemplateProvider ... templateProvidersToUpdate) {
            this.templateProvidersToUpdate(Arrays.asList(templateProvidersToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateProvidersToUpdate(Consumer<UpdateTemplateProvider.Builder> ... templateProvidersToUpdate) {
            this.templateProvidersToUpdate(Stream.of(templateProvidersToUpdate).map(c -> (UpdateTemplateProvider)((UpdateTemplateProvider.Builder)UpdateTemplateProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectRequest> {
        public Builder projectName(String var1);

        public Builder projectDescription(String var1);

        public Builder serviceCatalogProvisioningUpdateDetails(ServiceCatalogProvisioningUpdateDetails var1);

        default public Builder serviceCatalogProvisioningUpdateDetails(Consumer<ServiceCatalogProvisioningUpdateDetails.Builder> serviceCatalogProvisioningUpdateDetails) {
            return this.serviceCatalogProvisioningUpdateDetails((ServiceCatalogProvisioningUpdateDetails)((ServiceCatalogProvisioningUpdateDetails.Builder)ServiceCatalogProvisioningUpdateDetails.builder().applyMutation(serviceCatalogProvisioningUpdateDetails)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder templateProvidersToUpdate(Collection<UpdateTemplateProvider> var1);

        public Builder templateProvidersToUpdate(UpdateTemplateProvider ... var1);

        public Builder templateProvidersToUpdate(Consumer<UpdateTemplateProvider.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

