/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse;

public class CreateHubContentPresignedUrlsIterable
implements SdkIterable<CreateHubContentPresignedUrlsResponse> {
    private final SageMakerClient client;
    private final CreateHubContentPresignedUrlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public CreateHubContentPresignedUrlsIterable(SageMakerClient client, CreateHubContentPresignedUrlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new CreateHubContentPresignedUrlsResponseFetcher();
    }

    public Iterator<CreateHubContentPresignedUrlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuthorizedUrl> authorizedUrlConfigs() {
        Function<CreateHubContentPresignedUrlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.authorizedUrlConfigs() != null) {
                return response.authorizedUrlConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class CreateHubContentPresignedUrlsResponseFetcher
    implements SyncPageFetcher<CreateHubContentPresignedUrlsResponse> {
        private CreateHubContentPresignedUrlsResponseFetcher() {
        }

        public boolean hasNextPage(CreateHubContentPresignedUrlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CreateHubContentPresignedUrlsResponse nextPage(CreateHubContentPresignedUrlsResponse previousPage) {
            if (previousPage == null) {
                return CreateHubContentPresignedUrlsIterable.this.client.createHubContentPresignedUrls(CreateHubContentPresignedUrlsIterable.this.firstRequest);
            }
            return CreateHubContentPresignedUrlsIterable.this.client.createHubContentPresignedUrls((CreateHubContentPresignedUrlsRequest)((Object)CreateHubContentPresignedUrlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

