/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;

public class ListAlgorithmsIterable
implements SdkIterable<ListAlgorithmsResponse> {
    private final SageMakerClient client;
    private final ListAlgorithmsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAlgorithmsIterable(SageMakerClient client, ListAlgorithmsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAlgorithmsResponseFetcher();
    }

    public Iterator<ListAlgorithmsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AlgorithmSummary> algorithmSummaryList() {
        Function<ListAlgorithmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.algorithmSummaryList() != null) {
                return response.algorithmSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAlgorithmsResponseFetcher
    implements SyncPageFetcher<ListAlgorithmsResponse> {
        private ListAlgorithmsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlgorithmsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAlgorithmsResponse nextPage(ListAlgorithmsResponse previousPage) {
            if (previousPage == null) {
                return ListAlgorithmsIterable.this.client.listAlgorithms(ListAlgorithmsIterable.this.firstRequest);
            }
            return ListAlgorithmsIterable.this.client.listAlgorithms((ListAlgorithmsRequest)((Object)ListAlgorithmsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

