/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;

public class ListCandidatesForAutoMLJobIterable
implements SdkIterable<ListCandidatesForAutoMlJobResponse> {
    private final SageMakerClient client;
    private final ListCandidatesForAutoMlJobRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCandidatesForAutoMLJobIterable(SageMakerClient client, ListCandidatesForAutoMlJobRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCandidatesForAutoMlJobResponseFetcher();
    }

    public Iterator<ListCandidatesForAutoMlJobResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutoMLCandidate> candidates() {
        Function<ListCandidatesForAutoMlJobResponse, Iterator> getIterator = response -> {
            if (response != null && response.candidates() != null) {
                return response.candidates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCandidatesForAutoMlJobResponseFetcher
    implements SyncPageFetcher<ListCandidatesForAutoMlJobResponse> {
        private ListCandidatesForAutoMlJobResponseFetcher() {
        }

        public boolean hasNextPage(ListCandidatesForAutoMlJobResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCandidatesForAutoMlJobResponse nextPage(ListCandidatesForAutoMlJobResponse previousPage) {
            if (previousPage == null) {
                return ListCandidatesForAutoMLJobIterable.this.client.listCandidatesForAutoMLJob(ListCandidatesForAutoMLJobIterable.this.firstRequest);
            }
            return ListCandidatesForAutoMLJobIterable.this.client.listCandidatesForAutoMLJob((ListCandidatesForAutoMlJobRequest)((Object)ListCandidatesForAutoMLJobIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

