/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse;

public class ListClusterNodesIterable
implements SdkIterable<ListClusterNodesResponse> {
    private final SageMakerClient client;
    private final ListClusterNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterNodesIterable(SageMakerClient client, ListClusterNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterNodesResponseFetcher();
    }

    public Iterator<ListClusterNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterNodeSummary> clusterNodeSummaries() {
        Function<ListClusterNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterNodeSummaries() != null) {
                return response.clusterNodeSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterNodesResponseFetcher
    implements SyncPageFetcher<ListClusterNodesResponse> {
        private ListClusterNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterNodesResponse nextPage(ListClusterNodesResponse previousPage) {
            if (previousPage == null) {
                return ListClusterNodesIterable.this.client.listClusterNodes(ListClusterNodesIterable.this.firstRequest);
            }
            return ListClusterNodesIterable.this.client.listClusterNodes((ListClusterNodesRequest)((Object)ListClusterNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

