/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.CodeRepositorySummary;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;

public class ListCodeRepositoriesIterable
implements SdkIterable<ListCodeRepositoriesResponse> {
    private final SageMakerClient client;
    private final ListCodeRepositoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCodeRepositoriesIterable(SageMakerClient client, ListCodeRepositoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCodeRepositoriesResponseFetcher();
    }

    public Iterator<ListCodeRepositoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CodeRepositorySummary> codeRepositorySummaryList() {
        Function<ListCodeRepositoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeRepositorySummaryList() != null) {
                return response.codeRepositorySummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCodeRepositoriesResponseFetcher
    implements SyncPageFetcher<ListCodeRepositoriesResponse> {
        private ListCodeRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListCodeRepositoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCodeRepositoriesResponse nextPage(ListCodeRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return ListCodeRepositoriesIterable.this.client.listCodeRepositories(ListCodeRepositoriesIterable.this.firstRequest);
            }
            return ListCodeRepositoriesIterable.this.client.listCodeRepositories((ListCodeRepositoriesRequest)((Object)ListCodeRepositoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

