/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ContextSummary;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;

public class ListContextsIterable
implements SdkIterable<ListContextsResponse> {
    private final SageMakerClient client;
    private final ListContextsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContextsIterable(SageMakerClient client, ListContextsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContextsResponseFetcher();
    }

    public Iterator<ListContextsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContextSummary> contextSummaries() {
        Function<ListContextsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contextSummaries() != null) {
                return response.contextSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContextsResponseFetcher
    implements SyncPageFetcher<ListContextsResponse> {
        private ListContextsResponseFetcher() {
        }

        public boolean hasNextPage(ListContextsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContextsResponse nextPage(ListContextsResponse previousPage) {
            if (previousPage == null) {
                return ListContextsIterable.this.client.listContexts(ListContextsIterable.this.firstRequest);
            }
            return ListContextsIterable.this.client.listContexts((ListContextsRequest)((Object)ListContextsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

