/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJob;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;

public class ListInferenceRecommendationsJobsIterable
implements SdkIterable<ListInferenceRecommendationsJobsResponse> {
    private final SageMakerClient client;
    private final ListInferenceRecommendationsJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceRecommendationsJobsIterable(SageMakerClient client, ListInferenceRecommendationsJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceRecommendationsJobsResponseFetcher();
    }

    public Iterator<ListInferenceRecommendationsJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InferenceRecommendationsJob> inferenceRecommendationsJobs() {
        Function<ListInferenceRecommendationsJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceRecommendationsJobs() != null) {
                return response.inferenceRecommendationsJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInferenceRecommendationsJobsResponseFetcher
    implements SyncPageFetcher<ListInferenceRecommendationsJobsResponse> {
        private ListInferenceRecommendationsJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceRecommendationsJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceRecommendationsJobsResponse nextPage(ListInferenceRecommendationsJobsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceRecommendationsJobsIterable.this.client.listInferenceRecommendationsJobs(ListInferenceRecommendationsJobsIterable.this.firstRequest);
            }
            return ListInferenceRecommendationsJobsIterable.this.client.listInferenceRecommendationsJobs((ListInferenceRecommendationsJobsRequest)((Object)ListInferenceRecommendationsJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

