/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.PartnerAppSummary;

public class ListPartnerAppsPublisher
implements SdkPublisher<ListPartnerAppsResponse> {
    private final SageMakerAsyncClient client;
    private final ListPartnerAppsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPartnerAppsPublisher(SageMakerAsyncClient client, ListPartnerAppsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPartnerAppsPublisher(SageMakerAsyncClient client, ListPartnerAppsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPartnerAppsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPartnerAppsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PartnerAppSummary> summaries() {
        Function<ListPartnerAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPartnerAppsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPartnerAppsResponseFetcher
    implements AsyncPageFetcher<ListPartnerAppsResponse> {
        private ListPartnerAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListPartnerAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPartnerAppsResponse> nextPage(ListPartnerAppsResponse previousPage) {
            if (previousPage == null) {
                return ListPartnerAppsPublisher.this.client.listPartnerApps(ListPartnerAppsPublisher.this.firstRequest);
            }
            return ListPartnerAppsPublisher.this.client.listPartnerApps((ListPartnerAppsRequest)((Object)ListPartnerAppsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

