/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;

public class ListStageDevicesPublisher
implements SdkPublisher<ListStageDevicesResponse> {
    private final SageMakerAsyncClient client;
    private final ListStageDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStageDevicesPublisher(SageMakerAsyncClient client, ListStageDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStageDevicesPublisher(SageMakerAsyncClient client, ListStageDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStageDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStageDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeviceDeploymentSummary> deviceDeploymentSummaries() {
        Function<ListStageDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceDeploymentSummaries() != null) {
                return response.deviceDeploymentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStageDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStageDevicesResponseFetcher
    implements AsyncPageFetcher<ListStageDevicesResponse> {
        private ListStageDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListStageDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStageDevicesResponse> nextPage(ListStageDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListStageDevicesPublisher.this.client.listStageDevices(ListStageDevicesPublisher.this.firstRequest);
            }
            return ListStageDevicesPublisher.this.client.listStageDevices((ListStageDevicesRequest)((Object)ListStageDevicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

