/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.TrialSummary;

public class ListTrialsIterable
implements SdkIterable<ListTrialsResponse> {
    private final SageMakerClient client;
    private final ListTrialsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrialsIterable(SageMakerClient client, ListTrialsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrialsResponseFetcher();
    }

    public Iterator<ListTrialsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrialSummary> trialSummaries() {
        Function<ListTrialsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trialSummaries() != null) {
                return response.trialSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrialsResponseFetcher
    implements SyncPageFetcher<ListTrialsResponse> {
        private ListTrialsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrialsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrialsResponse nextPage(ListTrialsResponse previousPage) {
            if (previousPage == null) {
                return ListTrialsIterable.this.client.listTrials(ListTrialsIterable.this.firstRequest);
            }
            return ListTrialsIterable.this.client.listTrials((ListTrialsRequest)((Object)ListTrialsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

