/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.Workteam;

public class ListWorkteamsPublisher
implements SdkPublisher<ListWorkteamsResponse> {
    private final SageMakerAsyncClient client;
    private final ListWorkteamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkteamsPublisher(SageMakerAsyncClient client, ListWorkteamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkteamsPublisher(SageMakerAsyncClient client, ListWorkteamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkteamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkteamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Workteam> workteams() {
        Function<ListWorkteamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workteams() != null) {
                return response.workteams().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkteamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkteamsResponseFetcher
    implements AsyncPageFetcher<ListWorkteamsResponse> {
        private ListWorkteamsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkteamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkteamsResponse> nextPage(ListWorkteamsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkteamsPublisher.this.client.listWorkteams(ListWorkteamsPublisher.this.firstRequest);
            }
            return ListWorkteamsPublisher.this.client.listWorkteams((ListWorkteamsRequest)((Object)ListWorkteamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

