/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakermetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakermetrics.model.MetricStatistic;
import software.amazon.awssdk.services.sagemakermetrics.model.Period;
import software.amazon.awssdk.services.sagemakermetrics.model.XAxisType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricQuery> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricQuery.getter(MetricQuery::metricName)).setter(MetricQuery.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(MetricQuery.getter(MetricQuery::resourceArn)).setter(MetricQuery.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> METRIC_STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricStat").getter(MetricQuery.getter(MetricQuery::metricStatAsString)).setter(MetricQuery.setter(Builder::metricStat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStat").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Period").getter(MetricQuery.getter(MetricQuery::periodAsString)).setter(MetricQuery.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> X_AXIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XAxisType").getter(MetricQuery.getter(MetricQuery::xAxisTypeAsString)).setter(MetricQuery.setter(Builder::xAxisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisType").build()}).build();
    private static final SdkField<Long> START_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Start").getter(MetricQuery.getter(MetricQuery::start)).setter(MetricQuery.setter(Builder::start)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()}).build();
    private static final SdkField<Long> END_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("End").getter(MetricQuery.getter(MetricQuery::end)).setter(MetricQuery.setter(Builder::end)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, RESOURCE_ARN_FIELD, METRIC_STAT_FIELD, PERIOD_FIELD, X_AXIS_TYPE_FIELD, START_FIELD, END_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricQuery.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String resourceArn;
    private final String metricStat;
    private final String period;
    private final String xAxisType;
    private final Long start;
    private final Long end;

    private MetricQuery(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.resourceArn = builder.resourceArn;
        this.metricStat = builder.metricStat;
        this.period = builder.period;
        this.xAxisType = builder.xAxisType;
        this.start = builder.start;
        this.end = builder.end;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final MetricStatistic metricStat() {
        return MetricStatistic.fromValue(this.metricStat);
    }

    public final String metricStatAsString() {
        return this.metricStat;
    }

    public final Period period() {
        return Period.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final XAxisType xAxisType() {
        return XAxisType.fromValue(this.xAxisType);
    }

    public final String xAxisTypeAsString() {
        return this.xAxisType;
    }

    public final Long start() {
        return this.start;
    }

    public final Long end() {
        return this.end;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricStatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xAxisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.end());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQuery)) {
            return false;
        }
        MetricQuery other = (MetricQuery)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.metricStatAsString(), other.metricStatAsString()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.xAxisTypeAsString(), other.xAxisTypeAsString()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.end(), other.end());
    }

    public final String toString() {
        return ToString.builder((String)"MetricQuery").add("MetricName", (Object)this.metricName()).add("ResourceArn", (Object)this.resourceArn()).add("MetricStat", (Object)this.metricStatAsString()).add("Period", (Object)this.periodAsString()).add("XAxisType", (Object)this.xAxisTypeAsString()).add("Start", (Object)this.start()).add("End", (Object)this.end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "MetricStat": {
                return Optional.ofNullable(clazz.cast(this.metricStatAsString()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "XAxisType": {
                return Optional.ofNullable(clazz.cast(this.xAxisTypeAsString()));
            }
            case "Start": {
                return Optional.ofNullable(clazz.cast(this.start()));
            }
            case "End": {
                return Optional.ofNullable(clazz.cast(this.end()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("MetricStat", METRIC_STAT_FIELD);
        map.put("Period", PERIOD_FIELD);
        map.put("XAxisType", X_AXIS_TYPE_FIELD);
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricQuery, T> g) {
        return obj -> g.apply((MetricQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String resourceArn;
        private String metricStat;
        private String period;
        private String xAxisType;
        private Long start;
        private Long end;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQuery model) {
            this.metricName(model.metricName);
            this.resourceArn(model.resourceArn);
            this.metricStat(model.metricStat);
            this.period(model.period);
            this.xAxisType(model.xAxisType);
            this.start(model.start);
            this.end(model.end);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getMetricStat() {
            return this.metricStat;
        }

        public final void setMetricStat(String metricStat) {
            this.metricStat = metricStat;
        }

        @Override
        public final Builder metricStat(String metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        @Override
        public final Builder metricStat(MetricStatistic metricStat) {
            this.metricStat(metricStat == null ? null : metricStat.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(Period period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getXAxisType() {
            return this.xAxisType;
        }

        public final void setXAxisType(String xAxisType) {
            this.xAxisType = xAxisType;
        }

        @Override
        public final Builder xAxisType(String xAxisType) {
            this.xAxisType = xAxisType;
            return this;
        }

        @Override
        public final Builder xAxisType(XAxisType xAxisType) {
            this.xAxisType(xAxisType == null ? null : xAxisType.toString());
            return this;
        }

        public final Long getStart() {
            return this.start;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final Long getEnd() {
            return this.end;
        }

        public final void setEnd(Long end) {
            this.end = end;
        }

        @Override
        public final Builder end(Long end) {
            this.end = end;
            return this;
        }

        public MetricQuery build() {
            return new MetricQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricQuery> {
        public Builder metricName(String var1);

        public Builder resourceArn(String var1);

        public Builder metricStat(String var1);

        public Builder metricStat(MetricStatistic var1);

        public Builder period(String var1);

        public Builder period(Period var1);

        public Builder xAxisType(String var1);

        public Builder xAxisType(XAxisType var1);

        public Builder start(Long var1);

        public Builder end(Long var1);
    }
}

