/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntimehttp2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakerruntimehttp2.model.SageMakerRuntimeHttp2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeEndpointWithBidirectionalStreamRequest
extends SageMakerRuntimeHttp2Request
implements ToCopyableBuilder<Builder, InvokeEndpointWithBidirectionalStreamRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(InvokeEndpointWithBidirectionalStreamRequest.getter(InvokeEndpointWithBidirectionalStreamRequest::endpointName)).setter(InvokeEndpointWithBidirectionalStreamRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EndpointName").build()}).build();
    private static final SdkField<String> TARGET_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVariant").getter(InvokeEndpointWithBidirectionalStreamRequest.getter(InvokeEndpointWithBidirectionalStreamRequest::targetVariant)).setter(InvokeEndpointWithBidirectionalStreamRequest.setter(Builder::targetVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Target-Variant").build()}).build();
    private static final SdkField<String> MODEL_INVOCATION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelInvocationPath").getter(InvokeEndpointWithBidirectionalStreamRequest.getter(InvokeEndpointWithBidirectionalStreamRequest::modelInvocationPath)).setter(InvokeEndpointWithBidirectionalStreamRequest.setter(Builder::modelInvocationPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Model-Invocation-Path").build()}).build();
    private static final SdkField<String> MODEL_QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelQueryString").getter(InvokeEndpointWithBidirectionalStreamRequest.getter(InvokeEndpointWithBidirectionalStreamRequest::modelQueryString)).setter(InvokeEndpointWithBidirectionalStreamRequest.setter(Builder::modelQueryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Model-Query-String").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, TARGET_VARIANT_FIELD, MODEL_INVOCATION_PATH_FIELD, MODEL_QUERY_STRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeEndpointWithBidirectionalStreamRequest.memberNameToFieldInitializer();
    private final String endpointName;
    private final String targetVariant;
    private final String modelInvocationPath;
    private final String modelQueryString;

    private InvokeEndpointWithBidirectionalStreamRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.targetVariant = builder.targetVariant;
        this.modelInvocationPath = builder.modelInvocationPath;
        this.modelQueryString = builder.modelQueryString;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String targetVariant() {
        return this.targetVariant;
    }

    public final String modelInvocationPath() {
        return this.modelInvocationPath;
    }

    public final String modelQueryString() {
        return this.modelQueryString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInvocationPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQueryString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointWithBidirectionalStreamRequest)) {
            return false;
        }
        InvokeEndpointWithBidirectionalStreamRequest other = (InvokeEndpointWithBidirectionalStreamRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.targetVariant(), other.targetVariant()) && Objects.equals(this.modelInvocationPath(), other.modelInvocationPath()) && Objects.equals(this.modelQueryString(), other.modelQueryString());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeEndpointWithBidirectionalStreamRequest").add("EndpointName", (Object)this.endpointName()).add("TargetVariant", (Object)this.targetVariant()).add("ModelInvocationPath", (Object)this.modelInvocationPath()).add("ModelQueryString", (Object)this.modelQueryString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "TargetVariant": {
                return Optional.ofNullable(clazz.cast(this.targetVariant()));
            }
            case "ModelInvocationPath": {
                return Optional.ofNullable(clazz.cast(this.modelInvocationPath()));
            }
            case "ModelQueryString": {
                return Optional.ofNullable(clazz.cast(this.modelQueryString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("X-Amzn-SageMaker-Target-Variant", TARGET_VARIANT_FIELD);
        map.put("X-Amzn-SageMaker-Model-Invocation-Path", MODEL_INVOCATION_PATH_FIELD);
        map.put("X-Amzn-SageMaker-Model-Query-String", MODEL_QUERY_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointWithBidirectionalStreamRequest, T> g) {
        return obj -> g.apply((InvokeEndpointWithBidirectionalStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRuntimeHttp2Request.BuilderImpl
    implements Builder {
        private String endpointName;
        private String targetVariant;
        private String modelInvocationPath;
        private String modelQueryString;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointWithBidirectionalStreamRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.targetVariant(model.targetVariant);
            this.modelInvocationPath(model.modelInvocationPath);
            this.modelQueryString(model.modelQueryString);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getTargetVariant() {
            return this.targetVariant;
        }

        public final void setTargetVariant(String targetVariant) {
            this.targetVariant = targetVariant;
        }

        @Override
        public final Builder targetVariant(String targetVariant) {
            this.targetVariant = targetVariant;
            return this;
        }

        public final String getModelInvocationPath() {
            return this.modelInvocationPath;
        }

        public final void setModelInvocationPath(String modelInvocationPath) {
            this.modelInvocationPath = modelInvocationPath;
        }

        @Override
        public final Builder modelInvocationPath(String modelInvocationPath) {
            this.modelInvocationPath = modelInvocationPath;
            return this;
        }

        public final String getModelQueryString() {
            return this.modelQueryString;
        }

        public final void setModelQueryString(String modelQueryString) {
            this.modelQueryString = modelQueryString;
        }

        @Override
        public final Builder modelQueryString(String modelQueryString) {
            this.modelQueryString = modelQueryString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeEndpointWithBidirectionalStreamRequest build() {
            return new InvokeEndpointWithBidirectionalStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRuntimeHttp2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeEndpointWithBidirectionalStreamRequest> {
        public Builder endpointName(String var1);

        public Builder targetVariant(String var1);

        public Builder modelInvocationPath(String var1);

        public Builder modelQueryString(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

