/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.scheduler.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.scheduler.SchedulerAsyncClient;
import software.amazon.awssdk.services.scheduler.internal.UserAgentUtils;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsRequest;
import software.amazon.awssdk.services.scheduler.model.ListScheduleGroupsResponse;
import software.amazon.awssdk.services.scheduler.model.ScheduleGroupSummary;

public class ListScheduleGroupsPublisher
implements SdkPublisher<ListScheduleGroupsResponse> {
    private final SchedulerAsyncClient client;
    private final ListScheduleGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScheduleGroupsPublisher(SchedulerAsyncClient client, ListScheduleGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScheduleGroupsPublisher(SchedulerAsyncClient client, ListScheduleGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScheduleGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScheduleGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduleGroupSummary> scheduleGroups() {
        Function<ListScheduleGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduleGroups() != null) {
                return response.scheduleGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScheduleGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScheduleGroupsResponseFetcher
    implements AsyncPageFetcher<ListScheduleGroupsResponse> {
        private ListScheduleGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduleGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScheduleGroupsResponse> nextPage(ListScheduleGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduleGroupsPublisher.this.client.listScheduleGroups(ListScheduleGroupsPublisher.this.firstRequest);
            }
            return ListScheduleGroupsPublisher.this.client.listScheduleGroups((ListScheduleGroupsRequest)((Object)ListScheduleGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

