/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbLoadBalancerListener
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbLoadBalancerListener> {
    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstancePort").getter(AwsElbLoadBalancerListener.getter(AwsElbLoadBalancerListener::instancePort)).setter(AwsElbLoadBalancerListener.setter(Builder::instancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePort").build()}).build();
    private static final SdkField<String> INSTANCE_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProtocol").getter(AwsElbLoadBalancerListener.getter(AwsElbLoadBalancerListener::instanceProtocol)).setter(AwsElbLoadBalancerListener.setter(Builder::instanceProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProtocol").build()}).build();
    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LoadBalancerPort").getter(AwsElbLoadBalancerListener.getter(AwsElbLoadBalancerListener::loadBalancerPort)).setter(AwsElbLoadBalancerListener.setter(Builder::loadBalancerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(AwsElbLoadBalancerListener.getter(AwsElbLoadBalancerListener::protocol)).setter(AwsElbLoadBalancerListener.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SSL_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslCertificateId").getter(AwsElbLoadBalancerListener.getter(AwsElbLoadBalancerListener::sslCertificateId)).setter(AwsElbLoadBalancerListener.setter(Builder::sslCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCertificateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_PORT_FIELD, INSTANCE_PROTOCOL_FIELD, LOAD_BALANCER_PORT_FIELD, PROTOCOL_FIELD, SSL_CERTIFICATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsElbLoadBalancerListener.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer instancePort;
    private final String instanceProtocol;
    private final Integer loadBalancerPort;
    private final String protocol;
    private final String sslCertificateId;

    private AwsElbLoadBalancerListener(BuilderImpl builder) {
        this.instancePort = builder.instancePort;
        this.instanceProtocol = builder.instanceProtocol;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.protocol = builder.protocol;
        this.sslCertificateId = builder.sslCertificateId;
    }

    public final Integer instancePort() {
        return this.instancePort;
    }

    public final String instanceProtocol() {
        return this.instanceProtocol;
    }

    public final Integer loadBalancerPort() {
        return this.loadBalancerPort;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final String sslCertificateId() {
        return this.sslCertificateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCertificateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerListener)) {
            return false;
        }
        AwsElbLoadBalancerListener other = (AwsElbLoadBalancerListener)obj;
        return Objects.equals(this.instancePort(), other.instancePort()) && Objects.equals(this.instanceProtocol(), other.instanceProtocol()) && Objects.equals(this.loadBalancerPort(), other.loadBalancerPort()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.sslCertificateId(), other.sslCertificateId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbLoadBalancerListener").add("InstancePort", (Object)this.instancePort()).add("InstanceProtocol", (Object)this.instanceProtocol()).add("LoadBalancerPort", (Object)this.loadBalancerPort()).add("Protocol", (Object)this.protocol()).add("SslCertificateId", (Object)this.sslCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancePort": {
                return Optional.ofNullable(clazz.cast(this.instancePort()));
            }
            case "InstanceProtocol": {
                return Optional.ofNullable(clazz.cast(this.instanceProtocol()));
            }
            case "LoadBalancerPort": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerPort()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "SslCertificateId": {
                return Optional.ofNullable(clazz.cast(this.sslCertificateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstancePort", INSTANCE_PORT_FIELD);
        map.put("InstanceProtocol", INSTANCE_PROTOCOL_FIELD);
        map.put("LoadBalancerPort", LOAD_BALANCER_PORT_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("SslCertificateId", SSL_CERTIFICATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerListener, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerListener)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instancePort;
        private String instanceProtocol;
        private Integer loadBalancerPort;
        private String protocol;
        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerListener model) {
            this.instancePort(model.instancePort);
            this.instanceProtocol(model.instanceProtocol);
            this.loadBalancerPort(model.loadBalancerPort);
            this.protocol(model.protocol);
            this.sslCertificateId(model.sslCertificateId);
        }

        public final Integer getInstancePort() {
            return this.instancePort;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final String getInstanceProtocol() {
            return this.instanceProtocol;
        }

        public final void setInstanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
        }

        @Override
        public final Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
            return this;
        }

        public final Integer getLoadBalancerPort() {
            return this.loadBalancerPort;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getSslCertificateId() {
            return this.sslCertificateId;
        }

        public final void setSslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        public AwsElbLoadBalancerListener build() {
            return new AwsElbLoadBalancerListener(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbLoadBalancerListener> {
        public Builder instancePort(Integer var1);

        public Builder instanceProtocol(String var1);

        public Builder loadBalancerPort(Integer var1);

        public Builder protocol(String var1);

        public Builder sslCertificateId(String var1);
    }
}

