/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsWafRegionalRulePredicateListDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafRegionalRuleDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafRegionalRuleDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AwsWafRegionalRuleDetails.getter(AwsWafRegionalRuleDetails::metricName)).setter(AwsWafRegionalRuleDetails.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafRegionalRuleDetails.getter(AwsWafRegionalRuleDetails::name)).setter(AwsWafRegionalRuleDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<AwsWafRegionalRulePredicateListDetails>> PREDICATE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredicateList").getter(AwsWafRegionalRuleDetails.getter(AwsWafRegionalRuleDetails::predicateList)).setter(AwsWafRegionalRuleDetails.setter(Builder::predicateList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredicateList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafRegionalRulePredicateListDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(AwsWafRegionalRuleDetails.getter(AwsWafRegionalRuleDetails::ruleId)).setter(AwsWafRegionalRuleDetails.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD, PREDICATE_LIST_FIELD, RULE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsWafRegionalRuleDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String name;
    private final List<AwsWafRegionalRulePredicateListDetails> predicateList;
    private final String ruleId;

    private AwsWafRegionalRuleDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.predicateList = builder.predicateList;
        this.ruleId = builder.ruleId;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPredicateList() {
        return this.predicateList != null && !(this.predicateList instanceof SdkAutoConstructList);
    }

    public final List<AwsWafRegionalRulePredicateListDetails> predicateList() {
        return this.predicateList;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredicateList() ? this.predicateList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRegionalRuleDetails)) {
            return false;
        }
        AwsWafRegionalRuleDetails other = (AwsWafRegionalRuleDetails)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.name(), other.name()) && this.hasPredicateList() == other.hasPredicateList() && Objects.equals(this.predicateList(), other.predicateList()) && Objects.equals(this.ruleId(), other.ruleId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafRegionalRuleDetails").add("MetricName", (Object)this.metricName()).add("Name", (Object)this.name()).add("PredicateList", this.hasPredicateList() ? this.predicateList() : null).add("RuleId", (Object)this.ruleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PredicateList": {
                return Optional.ofNullable(clazz.cast(this.predicateList()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PredicateList", PREDICATE_LIST_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRegionalRuleDetails, T> g) {
        return obj -> g.apply((AwsWafRegionalRuleDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String name;
        private List<AwsWafRegionalRulePredicateListDetails> predicateList = DefaultSdkAutoConstructList.getInstance();
        private String ruleId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRegionalRuleDetails model) {
            this.metricName(model.metricName);
            this.name(model.name);
            this.predicateList(model.predicateList);
            this.ruleId(model.ruleId);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AwsWafRegionalRulePredicateListDetails.Builder> getPredicateList() {
            List<AwsWafRegionalRulePredicateListDetails.Builder> result = AwsWafRegionalRulePredicateListCopier.copyToBuilder(this.predicateList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredicateList(Collection<AwsWafRegionalRulePredicateListDetails.BuilderImpl> predicateList) {
            this.predicateList = AwsWafRegionalRulePredicateListCopier.copyFromBuilder(predicateList);
        }

        @Override
        public final Builder predicateList(Collection<AwsWafRegionalRulePredicateListDetails> predicateList) {
            this.predicateList = AwsWafRegionalRulePredicateListCopier.copy(predicateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicateList(AwsWafRegionalRulePredicateListDetails ... predicateList) {
            this.predicateList(Arrays.asList(predicateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicateList(Consumer<AwsWafRegionalRulePredicateListDetails.Builder> ... predicateList) {
            this.predicateList(Stream.of(predicateList).map(c -> (AwsWafRegionalRulePredicateListDetails)((AwsWafRegionalRulePredicateListDetails.Builder)AwsWafRegionalRulePredicateListDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public AwsWafRegionalRuleDetails build() {
            return new AwsWafRegionalRuleDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafRegionalRuleDetails> {
        public Builder metricName(String var1);

        public Builder name(String var1);

        public Builder predicateList(Collection<AwsWafRegionalRulePredicateListDetails> var1);

        public Builder predicateList(AwsWafRegionalRulePredicateListDetails ... var1);

        public Builder predicateList(Consumer<AwsWafRegionalRulePredicateListDetails.Builder> ... var1);

        public Builder ruleId(String var1);
    }
}

