/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorAuthStatus {
    ACTIVE("ACTIVE"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorAuthStatus> VALUE_MAP;
    private final String value;

    private ConnectorAuthStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorAuthStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorAuthStatus> knownValues() {
        EnumSet<ConnectorAuthStatus> knownValues = EnumSet.allOf(ConnectorAuthStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorAuthStatus.class, ConnectorAuthStatus::toString);
    }
}

