/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcesTrendsMetricsResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcesTrendsMetricsResult> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(ResourcesTrendsMetricsResult.getter(ResourcesTrendsMetricsResult::timestamp)).setter(ResourcesTrendsMetricsResult.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ResourcesTrendsValues> TRENDS_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrendsValues").getter(ResourcesTrendsMetricsResult.getter(ResourcesTrendsMetricsResult::trendsValues)).setter(ResourcesTrendsMetricsResult.setter(Builder::trendsValues)).constructor(ResourcesTrendsValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrendsValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TRENDS_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcesTrendsMetricsResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timestamp;
    private final ResourcesTrendsValues trendsValues;

    private ResourcesTrendsMetricsResult(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.trendsValues = builder.trendsValues;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final ResourcesTrendsValues trendsValues() {
        return this.trendsValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.trendsValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesTrendsMetricsResult)) {
            return false;
        }
        ResourcesTrendsMetricsResult other = (ResourcesTrendsMetricsResult)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.trendsValues(), other.trendsValues());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcesTrendsMetricsResult").add("Timestamp", (Object)this.timestamp()).add("TrendsValues", (Object)this.trendsValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "TrendsValues": {
                return Optional.ofNullable(clazz.cast(this.trendsValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("TrendsValues", TRENDS_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesTrendsMetricsResult, T> g) {
        return obj -> g.apply((ResourcesTrendsMetricsResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private ResourcesTrendsValues trendsValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesTrendsMetricsResult model) {
            this.timestamp(model.timestamp);
            this.trendsValues(model.trendsValues);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final ResourcesTrendsValues.Builder getTrendsValues() {
            return this.trendsValues != null ? this.trendsValues.toBuilder() : null;
        }

        public final void setTrendsValues(ResourcesTrendsValues.BuilderImpl trendsValues) {
            this.trendsValues = trendsValues != null ? trendsValues.build() : null;
        }

        @Override
        public final Builder trendsValues(ResourcesTrendsValues trendsValues) {
            this.trendsValues = trendsValues;
            return this;
        }

        public ResourcesTrendsMetricsResult build() {
            return new ResourcesTrendsMetricsResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcesTrendsMetricsResult> {
        public Builder timestamp(Instant var1);

        public Builder trendsValues(ResourcesTrendsValues var1);

        default public Builder trendsValues(Consumer<ResourcesTrendsValues.Builder> trendsValues) {
            return this.trendsValues((ResourcesTrendsValues)((ResourcesTrendsValues.Builder)ResourcesTrendsValues.builder().applyMutation(trendsValues)).build());
        }
    }
}

