/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingsV2Response;

public class GetFindingsV2Iterable
implements SdkIterable<GetFindingsV2Response> {
    private final SecurityHubClient client;
    private final GetFindingsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingsV2Iterable(SecurityHubClient client, GetFindingsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFindingsV2ResponseFetcher();
    }

    public Iterator<GetFindingsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Document> findings() {
        Function<GetFindingsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFindingsV2ResponseFetcher
    implements SyncPageFetcher<GetFindingsV2Response> {
        private GetFindingsV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingsV2Response nextPage(GetFindingsV2Response previousPage) {
            if (previousPage == null) {
                return GetFindingsV2Iterable.this.client.getFindingsV2(GetFindingsV2Iterable.this.firstRequest);
            }
            return GetFindingsV2Iterable.this.client.getFindingsV2((GetFindingsV2Request)((Object)GetFindingsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

