/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Response;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsMetricsResult;

public class GetResourcesTrendsV2Iterable
implements SdkIterable<GetResourcesTrendsV2Response> {
    private final SecurityHubClient client;
    private final GetResourcesTrendsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourcesTrendsV2Iterable(SecurityHubClient client, GetResourcesTrendsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetResourcesTrendsV2ResponseFetcher();
    }

    public Iterator<GetResourcesTrendsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourcesTrendsMetricsResult> trendsMetrics() {
        Function<GetResourcesTrendsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.trendsMetrics() != null) {
                return response.trendsMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourcesTrendsV2ResponseFetcher
    implements SyncPageFetcher<GetResourcesTrendsV2Response> {
        private GetResourcesTrendsV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesTrendsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetResourcesTrendsV2Response nextPage(GetResourcesTrendsV2Response previousPage) {
            if (previousPage == null) {
                return GetResourcesTrendsV2Iterable.this.client.getResourcesTrendsV2(GetResourcesTrendsV2Iterable.this.firstRequest);
            }
            return GetResourcesTrendsV2Iterable.this.client.getResourcesTrendsV2((GetResourcesTrendsV2Request)((Object)GetResourcesTrendsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

