/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.services.ssoadmin.model.Tag;
import software.amazon.awssdk.services.ssoadmin.model.TagListCopier;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerConfiguration;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrustedTokenIssuerRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, CreateTrustedTokenIssuerRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(CreateTrustedTokenIssuerRequest.getter(CreateTrustedTokenIssuerRequest::instanceArn)).setter(CreateTrustedTokenIssuerRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateTrustedTokenIssuerRequest.getter(CreateTrustedTokenIssuerRequest::name)).setter(CreateTrustedTokenIssuerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TRUSTED_TOKEN_ISSUER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustedTokenIssuerType").getter(CreateTrustedTokenIssuerRequest.getter(CreateTrustedTokenIssuerRequest::trustedTokenIssuerTypeAsString)).setter(CreateTrustedTokenIssuerRequest.setter(Builder::trustedTokenIssuerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerType").build()}).build();
    private static final SdkField<TrustedTokenIssuerConfiguration> TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrustedTokenIssuerConfiguration").getter(CreateTrustedTokenIssuerRequest.getter(CreateTrustedTokenIssuerRequest::trustedTokenIssuerConfiguration)).setter(CreateTrustedTokenIssuerRequest.setter(Builder::trustedTokenIssuerConfiguration)).constructor(TrustedTokenIssuerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedTokenIssuerConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTrustedTokenIssuerRequest.getter(CreateTrustedTokenIssuerRequest::clientToken)).setter(CreateTrustedTokenIssuerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTrustedTokenIssuerRequest.getter(CreateTrustedTokenIssuerRequest::tags)).setter(CreateTrustedTokenIssuerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, NAME_FIELD, TRUSTED_TOKEN_ISSUER_TYPE_FIELD, TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTrustedTokenIssuerRequest.memberNameToFieldInitializer();
    private final String instanceArn;
    private final String name;
    private final String trustedTokenIssuerType;
    private final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateTrustedTokenIssuerRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.name = builder.name;
        this.trustedTokenIssuerType = builder.trustedTokenIssuerType;
        this.trustedTokenIssuerConfiguration = builder.trustedTokenIssuerConfiguration;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String name() {
        return this.name;
    }

    public final TrustedTokenIssuerType trustedTokenIssuerType() {
        return TrustedTokenIssuerType.fromValue(this.trustedTokenIssuerType);
    }

    public final String trustedTokenIssuerTypeAsString() {
        return this.trustedTokenIssuerType;
    }

    public final TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration() {
        return this.trustedTokenIssuerConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustedTokenIssuerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustedTokenIssuerRequest)) {
            return false;
        }
        CreateTrustedTokenIssuerRequest other = (CreateTrustedTokenIssuerRequest)((Object)obj);
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.trustedTokenIssuerTypeAsString(), other.trustedTokenIssuerTypeAsString()) && Objects.equals(this.trustedTokenIssuerConfiguration(), other.trustedTokenIssuerConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrustedTokenIssuerRequest").add("InstanceArn", (Object)this.instanceArn()).add("Name", (Object)this.name()).add("TrustedTokenIssuerType", (Object)this.trustedTokenIssuerTypeAsString()).add("TrustedTokenIssuerConfiguration", (Object)this.trustedTokenIssuerConfiguration()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TrustedTokenIssuerType": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerTypeAsString()));
            }
            case "TrustedTokenIssuerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.trustedTokenIssuerConfiguration()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("TrustedTokenIssuerType", TRUSTED_TOKEN_ISSUER_TYPE_FIELD);
        map.put("TrustedTokenIssuerConfiguration", TRUSTED_TOKEN_ISSUER_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustedTokenIssuerRequest, T> g) {
        return obj -> g.apply((CreateTrustedTokenIssuerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String name;
        private String trustedTokenIssuerType;
        private TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustedTokenIssuerRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.name(model.name);
            this.trustedTokenIssuerType(model.trustedTokenIssuerType);
            this.trustedTokenIssuerConfiguration(model.trustedTokenIssuerConfiguration);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTrustedTokenIssuerType() {
            return this.trustedTokenIssuerType;
        }

        public final void setTrustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
        }

        @Override
        public final Builder trustedTokenIssuerType(String trustedTokenIssuerType) {
            this.trustedTokenIssuerType = trustedTokenIssuerType;
            return this;
        }

        @Override
        public final Builder trustedTokenIssuerType(TrustedTokenIssuerType trustedTokenIssuerType) {
            this.trustedTokenIssuerType(trustedTokenIssuerType == null ? null : trustedTokenIssuerType.toString());
            return this;
        }

        public final TrustedTokenIssuerConfiguration.Builder getTrustedTokenIssuerConfiguration() {
            return this.trustedTokenIssuerConfiguration != null ? this.trustedTokenIssuerConfiguration.toBuilder() : null;
        }

        public final void setTrustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration.BuilderImpl trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration != null ? trustedTokenIssuerConfiguration.build() : null;
        }

        @Override
        public final Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration trustedTokenIssuerConfiguration) {
            this.trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustedTokenIssuerRequest build() {
            return new CreateTrustedTokenIssuerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrustedTokenIssuerRequest> {
        public Builder instanceArn(String var1);

        public Builder name(String var1);

        public Builder trustedTokenIssuerType(String var1);

        public Builder trustedTokenIssuerType(TrustedTokenIssuerType var1);

        public Builder trustedTokenIssuerConfiguration(TrustedTokenIssuerConfiguration var1);

        default public Builder trustedTokenIssuerConfiguration(Consumer<TrustedTokenIssuerConfiguration.Builder> trustedTokenIssuerConfiguration) {
            return this.trustedTokenIssuerConfiguration((TrustedTokenIssuerConfiguration)((TrustedTokenIssuerConfiguration.Builder)TrustedTokenIssuerConfiguration.builder().applyMutation(trustedTokenIssuerConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

