/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.KmsKeyStatus;
import software.amazon.awssdk.services.ssoadmin.model.KmsKeyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionConfigurationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionConfigurationDetails> {
    private static final SdkField<String> KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyType").getter(EncryptionConfigurationDetails.getter(EncryptionConfigurationDetails::keyTypeAsString)).setter(EncryptionConfigurationDetails.setter(Builder::keyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyType").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(EncryptionConfigurationDetails.getter(EncryptionConfigurationDetails::kmsKeyArn)).setter(EncryptionConfigurationDetails.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionStatus").getter(EncryptionConfigurationDetails.getter(EncryptionConfigurationDetails::encryptionStatusAsString)).setter(EncryptionConfigurationDetails.setter(Builder::encryptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStatus").build()}).build();
    private static final SdkField<String> ENCRYPTION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionStatusReason").getter(EncryptionConfigurationDetails.getter(EncryptionConfigurationDetails::encryptionStatusReason)).setter(EncryptionConfigurationDetails.setter(Builder::encryptionStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_TYPE_FIELD, KMS_KEY_ARN_FIELD, ENCRYPTION_STATUS_FIELD, ENCRYPTION_STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EncryptionConfigurationDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyType;
    private final String kmsKeyArn;
    private final String encryptionStatus;
    private final String encryptionStatusReason;

    private EncryptionConfigurationDetails(BuilderImpl builder) {
        this.keyType = builder.keyType;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.encryptionStatus = builder.encryptionStatus;
        this.encryptionStatusReason = builder.encryptionStatusReason;
    }

    public final KmsKeyType keyType() {
        return KmsKeyType.fromValue(this.keyType);
    }

    public final String keyTypeAsString() {
        return this.keyType;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final KmsKeyStatus encryptionStatus() {
        return KmsKeyStatus.fromValue(this.encryptionStatus);
    }

    public final String encryptionStatusAsString() {
        return this.encryptionStatus;
    }

    public final String encryptionStatusReason() {
        return this.encryptionStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionStatusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfigurationDetails)) {
            return false;
        }
        EncryptionConfigurationDetails other = (EncryptionConfigurationDetails)obj;
        return Objects.equals(this.keyTypeAsString(), other.keyTypeAsString()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.encryptionStatusAsString(), other.encryptionStatusAsString()) && Objects.equals(this.encryptionStatusReason(), other.encryptionStatusReason());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionConfigurationDetails").add("KeyType", (Object)this.keyTypeAsString()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("EncryptionStatus", (Object)this.encryptionStatusAsString()).add("EncryptionStatusReason", (Object)this.encryptionStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyType": {
                return Optional.ofNullable(clazz.cast(this.keyTypeAsString()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "EncryptionStatus": {
                return Optional.ofNullable(clazz.cast(this.encryptionStatusAsString()));
            }
            case "EncryptionStatusReason": {
                return Optional.ofNullable(clazz.cast(this.encryptionStatusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KeyType", KEY_TYPE_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("EncryptionStatus", ENCRYPTION_STATUS_FIELD);
        map.put("EncryptionStatusReason", ENCRYPTION_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfigurationDetails, T> g) {
        return obj -> g.apply((EncryptionConfigurationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyType;
        private String kmsKeyArn;
        private String encryptionStatus;
        private String encryptionStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfigurationDetails model) {
            this.keyType(model.keyType);
            this.kmsKeyArn(model.kmsKeyArn);
            this.encryptionStatus(model.encryptionStatus);
            this.encryptionStatusReason(model.encryptionStatusReason);
        }

        public final String getKeyType() {
            return this.keyType;
        }

        public final void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public final Builder keyType(String keyType) {
            this.keyType = keyType;
            return this;
        }

        @Override
        public final Builder keyType(KmsKeyType keyType) {
            this.keyType(keyType == null ? null : keyType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getEncryptionStatus() {
            return this.encryptionStatus;
        }

        public final void setEncryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
        }

        @Override
        public final Builder encryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
            return this;
        }

        @Override
        public final Builder encryptionStatus(KmsKeyStatus encryptionStatus) {
            this.encryptionStatus(encryptionStatus == null ? null : encryptionStatus.toString());
            return this;
        }

        public final String getEncryptionStatusReason() {
            return this.encryptionStatusReason;
        }

        public final void setEncryptionStatusReason(String encryptionStatusReason) {
            this.encryptionStatusReason = encryptionStatusReason;
        }

        @Override
        public final Builder encryptionStatusReason(String encryptionStatusReason) {
            this.encryptionStatusReason = encryptionStatusReason;
            return this;
        }

        public EncryptionConfigurationDetails build() {
            return new EncryptionConfigurationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionConfigurationDetails> {
        public Builder keyType(String var1);

        public Builder keyType(KmsKeyType var1);

        public Builder kmsKeyArn(String var1);

        public Builder encryptionStatus(String var1);

        public Builder encryptionStatus(KmsKeyStatus var1);

        public Builder encryptionStatusReason(String var1);
    }
}

