/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BooleanEnumType {
    TRUE("TRUE"),
    FALSE("FALSE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BooleanEnumType> VALUE_MAP;
    private final String value;

    private BooleanEnumType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BooleanEnumType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BooleanEnumType> knownValues() {
        EnumSet<BooleanEnumType> knownValues = EnumSet.allOf(BooleanEnumType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BooleanEnumType.class, BooleanEnumType::toString);
    }
}

