/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workdocs.model.AdditionalResponseFieldType;
import software.amazon.awssdk.services.workdocs.model.AdditionalResponseFieldsListCopier;
import software.amazon.awssdk.services.workdocs.model.Filters;
import software.amazon.awssdk.services.workdocs.model.SearchQueryScopeType;
import software.amazon.awssdk.services.workdocs.model.SearchQueryScopeTypeListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchResultSortListCopier;
import software.amazon.awssdk.services.workdocs.model.SearchSortResult;
import software.amazon.awssdk.services.workdocs.model.WorkDocsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchResourcesRequest
extends WorkDocsRequest
implements ToCopyableBuilder<Builder, SearchResourcesRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationToken").getter(SearchResourcesRequest.getter(SearchResourcesRequest::authenticationToken)).setter(SearchResourcesRequest.setter(Builder::authenticationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()}).build();
    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryText").getter(SearchResourcesRequest.getter(SearchResourcesRequest::queryText)).setter(SearchResourcesRequest.setter(Builder::queryText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()}).build();
    private static final SdkField<List<String>> QUERY_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryScopes").getter(SearchResourcesRequest.getter(SearchResourcesRequest::queryScopesAsStrings)).setter(SearchResourcesRequest.setter(Builder::queryScopesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(SearchResourcesRequest.getter(SearchResourcesRequest::organizationId)).setter(SearchResourcesRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_RESPONSE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalResponseFields").getter(SearchResourcesRequest.getter(SearchResourcesRequest::additionalResponseFieldsAsStrings)).setter(SearchResourcesRequest.setter(Builder::additionalResponseFieldsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalResponseFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Filters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(SearchResourcesRequest.getter(SearchResourcesRequest::filters)).setter(SearchResourcesRequest.setter(Builder::filters)).constructor(Filters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<SearchSortResult>> ORDER_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderBy").getter(SearchResourcesRequest.getter(SearchResourcesRequest::orderBy)).setter(SearchResourcesRequest.setter(Builder::orderBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSortResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(SearchResourcesRequest.getter(SearchResourcesRequest::limit)).setter(SearchResourcesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(SearchResourcesRequest.getter(SearchResourcesRequest::marker)).setter(SearchResourcesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD, QUERY_TEXT_FIELD, QUERY_SCOPES_FIELD, ORGANIZATION_ID_FIELD, ADDITIONAL_RESPONSE_FIELDS_FIELD, FILTERS_FIELD, ORDER_BY_FIELD, LIMIT_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchResourcesRequest.memberNameToFieldInitializer();
    private final String authenticationToken;
    private final String queryText;
    private final List<String> queryScopes;
    private final String organizationId;
    private final List<String> additionalResponseFields;
    private final Filters filters;
    private final List<SearchSortResult> orderBy;
    private final Integer limit;
    private final String marker;

    private SearchResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.queryText = builder.queryText;
        this.queryScopes = builder.queryScopes;
        this.organizationId = builder.organizationId;
        this.additionalResponseFields = builder.additionalResponseFields;
        this.filters = builder.filters;
        this.orderBy = builder.orderBy;
        this.limit = builder.limit;
        this.marker = builder.marker;
    }

    public final String authenticationToken() {
        return this.authenticationToken;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final List<SearchQueryScopeType> queryScopes() {
        return SearchQueryScopeTypeListCopier.copyStringToEnum(this.queryScopes);
    }

    public final boolean hasQueryScopes() {
        return this.queryScopes != null && !(this.queryScopes instanceof SdkAutoConstructList);
    }

    public final List<String> queryScopesAsStrings() {
        return this.queryScopes;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final List<AdditionalResponseFieldType> additionalResponseFields() {
        return AdditionalResponseFieldsListCopier.copyStringToEnum(this.additionalResponseFields);
    }

    public final boolean hasAdditionalResponseFields() {
        return this.additionalResponseFields != null && !(this.additionalResponseFields instanceof SdkAutoConstructList);
    }

    public final List<String> additionalResponseFieldsAsStrings() {
        return this.additionalResponseFields;
    }

    public final Filters filters() {
        return this.filters;
    }

    public final boolean hasOrderBy() {
        return this.orderBy != null && !(this.orderBy instanceof SdkAutoConstructList);
    }

    public final List<SearchSortResult> orderBy() {
        return this.orderBy;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryText());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryScopes() ? this.queryScopesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalResponseFields() ? this.additionalResponseFieldsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderBy() ? this.orderBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest)((Object)obj);
        return Objects.equals(this.authenticationToken(), other.authenticationToken()) && Objects.equals(this.queryText(), other.queryText()) && this.hasQueryScopes() == other.hasQueryScopes() && Objects.equals(this.queryScopesAsStrings(), other.queryScopesAsStrings()) && Objects.equals(this.organizationId(), other.organizationId()) && this.hasAdditionalResponseFields() == other.hasAdditionalResponseFields() && Objects.equals(this.additionalResponseFieldsAsStrings(), other.additionalResponseFieldsAsStrings()) && Objects.equals(this.filters(), other.filters()) && this.hasOrderBy() == other.hasOrderBy() && Objects.equals(this.orderBy(), other.orderBy()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"SearchResourcesRequest").add("AuthenticationToken", (Object)(this.authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryText", (Object)(this.queryText() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryScopes", this.hasQueryScopes() ? this.queryScopesAsStrings() : null).add("OrganizationId", (Object)this.organizationId()).add("AdditionalResponseFields", this.hasAdditionalResponseFields() ? this.additionalResponseFieldsAsStrings() : null).add("Filters", (Object)this.filters()).add("OrderBy", this.hasOrderBy() ? this.orderBy() : null).add("Limit", (Object)this.limit()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationToken": {
                return Optional.ofNullable(clazz.cast(this.authenticationToken()));
            }
            case "QueryText": {
                return Optional.ofNullable(clazz.cast(this.queryText()));
            }
            case "QueryScopes": {
                return Optional.ofNullable(clazz.cast(this.queryScopesAsStrings()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "AdditionalResponseFields": {
                return Optional.ofNullable(clazz.cast(this.additionalResponseFieldsAsStrings()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "OrderBy": {
                return Optional.ofNullable(clazz.cast(this.orderBy()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("QueryScopes", QUERY_SCOPES_FIELD);
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("AdditionalResponseFields", ADDITIONAL_RESPONSE_FIELDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("OrderBy", ORDER_BY_FIELD);
        map.put("Limit", LIMIT_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesRequest, T> g) {
        return obj -> g.apply((SearchResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkDocsRequest.BuilderImpl
    implements Builder {
        private String authenticationToken;
        private String queryText;
        private List<String> queryScopes = DefaultSdkAutoConstructList.getInstance();
        private String organizationId;
        private List<String> additionalResponseFields = DefaultSdkAutoConstructList.getInstance();
        private Filters filters;
        private List<SearchSortResult> orderBy = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesRequest model) {
            super(model);
            this.authenticationToken(model.authenticationToken);
            this.queryText(model.queryText);
            this.queryScopesWithStrings(model.queryScopes);
            this.organizationId(model.organizationId);
            this.additionalResponseFieldsWithStrings(model.additionalResponseFields);
            this.filters(model.filters);
            this.orderBy(model.orderBy);
            this.limit(model.limit);
            this.marker(model.marker);
        }

        public final String getAuthenticationToken() {
            return this.authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getQueryText() {
            return this.queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final Collection<String> getQueryScopes() {
            if (this.queryScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryScopes;
        }

        public final void setQueryScopes(Collection<String> queryScopes) {
            this.queryScopes = SearchQueryScopeTypeListCopier.copy(queryScopes);
        }

        @Override
        public final Builder queryScopesWithStrings(Collection<String> queryScopes) {
            this.queryScopes = SearchQueryScopeTypeListCopier.copy(queryScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryScopesWithStrings(String ... queryScopes) {
            this.queryScopesWithStrings(Arrays.asList(queryScopes));
            return this;
        }

        @Override
        public final Builder queryScopes(Collection<SearchQueryScopeType> queryScopes) {
            this.queryScopes = SearchQueryScopeTypeListCopier.copyEnumToString(queryScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryScopes(SearchQueryScopeType ... queryScopes) {
            this.queryScopes(Arrays.asList(queryScopes));
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Collection<String> getAdditionalResponseFields() {
            if (this.additionalResponseFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalResponseFields;
        }

        public final void setAdditionalResponseFields(Collection<String> additionalResponseFields) {
            this.additionalResponseFields = AdditionalResponseFieldsListCopier.copy(additionalResponseFields);
        }

        @Override
        public final Builder additionalResponseFieldsWithStrings(Collection<String> additionalResponseFields) {
            this.additionalResponseFields = AdditionalResponseFieldsListCopier.copy(additionalResponseFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResponseFieldsWithStrings(String ... additionalResponseFields) {
            this.additionalResponseFieldsWithStrings(Arrays.asList(additionalResponseFields));
            return this;
        }

        @Override
        public final Builder additionalResponseFields(Collection<AdditionalResponseFieldType> additionalResponseFields) {
            this.additionalResponseFields = AdditionalResponseFieldsListCopier.copyEnumToString(additionalResponseFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalResponseFields(AdditionalResponseFieldType ... additionalResponseFields) {
            this.additionalResponseFields(Arrays.asList(additionalResponseFields));
            return this;
        }

        public final Filters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final List<SearchSortResult.Builder> getOrderBy() {
            List<SearchSortResult.Builder> result = SearchResultSortListCopier.copyToBuilder(this.orderBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderBy(Collection<SearchSortResult.BuilderImpl> orderBy) {
            this.orderBy = SearchResultSortListCopier.copyFromBuilder(orderBy);
        }

        @Override
        public final Builder orderBy(Collection<SearchSortResult> orderBy) {
            this.orderBy = SearchResultSortListCopier.copy(orderBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(SearchSortResult ... orderBy) {
            this.orderBy(Arrays.asList(orderBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderBy(Consumer<SearchSortResult.Builder> ... orderBy) {
            this.orderBy(Stream.of(orderBy).map(c -> (SearchSortResult)((SearchSortResult.Builder)SearchSortResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchResourcesRequest build() {
            return new SearchResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkDocsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchResourcesRequest> {
        public Builder authenticationToken(String var1);

        public Builder queryText(String var1);

        public Builder queryScopesWithStrings(Collection<String> var1);

        public Builder queryScopesWithStrings(String ... var1);

        public Builder queryScopes(Collection<SearchQueryScopeType> var1);

        public Builder queryScopes(SearchQueryScopeType ... var1);

        public Builder organizationId(String var1);

        public Builder additionalResponseFieldsWithStrings(Collection<String> var1);

        public Builder additionalResponseFieldsWithStrings(String ... var1);

        public Builder additionalResponseFields(Collection<AdditionalResponseFieldType> var1);

        public Builder additionalResponseFields(AdditionalResponseFieldType ... var1);

        public Builder filters(Filters var1);

        default public Builder filters(Consumer<Filters.Builder> filters) {
            return this.filters((Filters)((Filters.Builder)Filters.builder().applyMutation(filters)).build());
        }

        public Builder orderBy(Collection<SearchSortResult> var1);

        public Builder orderBy(SearchSortResult ... var1);

        public Builder orderBy(Consumer<SearchSortResult.Builder> ... var1);

        public Builder limit(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

