/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.Subscription;

public class DescribeNotificationSubscriptionsIterable
implements SdkIterable<DescribeNotificationSubscriptionsResponse> {
    private final WorkDocsClient client;
    private final DescribeNotificationSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeNotificationSubscriptionsIterable(WorkDocsClient client, DescribeNotificationSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeNotificationSubscriptionsResponseFetcher();
    }

    public Iterator<DescribeNotificationSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subscription> subscriptions() {
        Function<DescribeNotificationSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subscriptions() != null) {
                return response.subscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeNotificationSubscriptionsResponseFetcher
    implements SyncPageFetcher<DescribeNotificationSubscriptionsResponse> {
        private DescribeNotificationSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeNotificationSubscriptionsResponse nextPage(DescribeNotificationSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationSubscriptionsIterable.this.client.describeNotificationSubscriptions(DescribeNotificationSubscriptionsIterable.this.firstRequest);
            }
            return DescribeNotificationSubscriptionsIterable.this.client.describeNotificationSubscriptions((DescribeNotificationSubscriptionsRequest)((Object)DescribeNotificationSubscriptionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

