/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.encrypt.field.util;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.encrypt.context.CryptoContext;
import top.continew.starter.encrypt.encryptor.IEncryptor;
import top.continew.starter.encrypt.enums.Algorithm;
import top.continew.starter.encrypt.field.annotation.FieldEncrypt;
import top.continew.starter.encrypt.field.autoconfigure.FieldEncryptProperties;

public class EncryptHelper {
    private static final Logger log = LoggerFactory.getLogger(EncryptHelper.class);
    private static FieldEncryptProperties defaultProperties;
    private static final Map<Integer, IEncryptor> ENCRYPTOR_CACHE;

    private EncryptHelper() {
    }

    public static void init(FieldEncryptProperties properties) {
        defaultProperties = properties;
    }

    public static IEncryptor registerAndGetEncryptor(CryptoContext cryptoContext) {
        int key = cryptoContext.hashCode();
        return ENCRYPTOR_CACHE.computeIfAbsent(key, k -> cryptoContext.getEncryptor().equals(IEncryptor.class) ? (IEncryptor)ReflectUtil.newInstance((Class)cryptoContext.getAlgorithm().getEncryptor(), (Object[])new Object[]{cryptoContext}) : (IEncryptor)ReflectUtil.newInstance((Class)cryptoContext.getEncryptor(), (Object[])new Object[]{cryptoContext}));
    }

    public static FieldEncrypt getFieldEncrypt(Object obj, String fieldName) throws NoSuchFieldException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        return field.getAnnotation(FieldEncrypt.class);
    }

    public static String encrypt(String value, FieldEncrypt fieldEncrypt) {
        if (CharSequenceUtil.isBlank((CharSequence)value) || fieldEncrypt == null) {
            return value;
        }
        String ciphertext = value;
        try {
            CryptoContext cryptoContext = EncryptHelper.buildCryptoContext(fieldEncrypt);
            IEncryptor encryptor = EncryptHelper.registerAndGetEncryptor(cryptoContext);
            ciphertext = encryptor.encrypt(ciphertext);
        }
        catch (Exception e) {
            log.warn("\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u52a0\u5bc6\u914d\u7f6e\uff0c\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return ciphertext;
    }

    public static String encrypt(String value) {
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            return value;
        }
        String ciphertext = value;
        try {
            CryptoContext cryptoContext = EncryptHelper.buildCryptoContext();
            IEncryptor encryptor = EncryptHelper.registerAndGetEncryptor(cryptoContext);
            ciphertext = encryptor.encrypt(ciphertext);
        }
        catch (Exception e) {
            log.warn("\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u52a0\u5bc6\u914d\u7f6e\uff0c\u5904\u7406\u52a0\u5bc6\u5b57\u6bb5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return ciphertext;
    }

    public static String decrypt(String value, FieldEncrypt fieldEncrypt) {
        if (CharSequenceUtil.isBlank((CharSequence)value) || fieldEncrypt == null) {
            return value;
        }
        String plaintext = value;
        try {
            CryptoContext cryptoContext = EncryptHelper.buildCryptoContext(fieldEncrypt);
            IEncryptor encryptor = EncryptHelper.registerAndGetEncryptor(cryptoContext);
            plaintext = encryptor.decrypt(plaintext);
        }
        catch (Exception e) {
            log.warn("\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u52a0\u5bc6\u914d\u7f6e\uff0c\u5904\u7406\u89e3\u5bc6\u5b57\u6bb5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return plaintext;
    }

    public static String decrypt(String value) {
        if (CharSequenceUtil.isBlank((CharSequence)value)) {
            return value;
        }
        String plaintext = value;
        try {
            CryptoContext cryptoContext = EncryptHelper.buildCryptoContext();
            IEncryptor encryptor = EncryptHelper.registerAndGetEncryptor(cryptoContext);
            plaintext = encryptor.decrypt(plaintext);
        }
        catch (Exception e) {
            log.warn("\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u52a0\u5bc6\u914d\u7f6e\uff0c\u5904\u7406\u89e3\u5bc6\u5b57\u6bb5\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return plaintext;
    }

    private static CryptoContext buildCryptoContext(FieldEncrypt fieldEncrypt) {
        CryptoContext cryptoContext = new CryptoContext();
        cryptoContext.setAlgorithm(fieldEncrypt.value() == Algorithm.DEFAULT ? defaultProperties.getAlgorithm() : fieldEncrypt.value());
        cryptoContext.setEncryptor(fieldEncrypt.encryptor().equals(IEncryptor.class) ? IEncryptor.class : fieldEncrypt.encryptor());
        cryptoContext.setPassword(fieldEncrypt.password().isEmpty() ? defaultProperties.getPassword() : fieldEncrypt.password());
        cryptoContext.setPrivateKey(fieldEncrypt.privateKey().isEmpty() ? defaultProperties.getPrivateKey() : fieldEncrypt.privateKey());
        cryptoContext.setPublicKey(fieldEncrypt.publicKey().isEmpty() ? defaultProperties.getPublicKey() : fieldEncrypt.publicKey());
        return cryptoContext;
    }

    private static CryptoContext buildCryptoContext() {
        CryptoContext cryptoContext = new CryptoContext();
        cryptoContext.setAlgorithm(defaultProperties.getAlgorithm());
        cryptoContext.setEncryptor(IEncryptor.class);
        cryptoContext.setPassword(defaultProperties.getPassword());
        cryptoContext.setPrivateKey(defaultProperties.getPrivateKey());
        cryptoContext.setPublicKey(defaultProperties.getPublicKey());
        return cryptoContext;
    }

    static {
        ENCRYPTOR_CACHE = new ConcurrentHashMap<Integer, IEncryptor>();
    }
}

