/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.autoconfigure;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import jakarta.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.ResolvableType;
import top.continew.starter.extension.tenant.TenantDataSourceHandler;
import top.continew.starter.extension.tenant.annotation.ConditionalOnEnabledTenant;
import top.continew.starter.extension.tenant.aop.TenantIgnoreAspect;
import top.continew.starter.extension.tenant.autoconfigure.TenantProperties;
import top.continew.starter.extension.tenant.config.TenantProvider;
import top.continew.starter.extension.tenant.handler.datasource.DefaultTenantDataSourceHandler;
import top.continew.starter.extension.tenant.handler.datasource.TenantDataSourceAdvisor;
import top.continew.starter.extension.tenant.handler.datasource.TenantDataSourceInterceptor;
import top.continew.starter.extension.tenant.handler.line.DefaultTenantLineHandler;

@AutoConfiguration
@ConditionalOnEnabledTenant
public class TenantAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TenantAutoConfiguration.class);
    private final TenantProperties tenantProperties;

    public TenantAutoConfiguration(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantIgnoreAspect tenantIgnoreAspect() {
        return new TenantIgnoreAspect();
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        return new TenantLineInnerInterceptor(tenantLineHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantLineHandler tenantLineHandler() {
        return new DefaultTenantLineHandler(this.tenantProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.baomidou.dynamic.datasource.DynamicRoutingDataSource"})
    public TenantDataSourceAdvisor tenantDataSourceAdvisor(TenantDataSourceInterceptor tenantDataSourceInterceptor) {
        return new TenantDataSourceAdvisor(tenantDataSourceInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.baomidou.dynamic.datasource.DynamicRoutingDataSource"})
    public TenantDataSourceInterceptor tenantDataSourceInterceptor(TenantDataSourceHandler tenantDataSourceHandler) {
        return new TenantDataSourceInterceptor(tenantDataSourceHandler);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"com.baomidou.dynamic.datasource.DynamicRoutingDataSource"})
    public TenantDataSourceHandler tenantDataSourceHandler(DataSource dataSource) {
        return new DefaultTenantDataSourceHandler(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantProvider tenantProvider() {
        if (log.isErrorEnabled()) {
            log.error("Consider defining a bean of type '{}' in your configuration.", (Object)ResolvableType.forClass(TenantProvider.class));
        }
        throw new NoSuchBeanDefinitionException(TenantProvider.class);
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'Tenant' completed initialization.");
    }
}

