/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.extension.tenant.handler.line;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import java.util.Collection;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.continew.starter.extension.tenant.autoconfigure.TenantProperties;
import top.continew.starter.extension.tenant.context.TenantContextHolder;
import top.continew.starter.extension.tenant.enums.TenantIsolationLevel;

public class DefaultTenantLineHandler
implements TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultTenantLineHandler.class);
    private final TenantProperties tenantProperties;

    public DefaultTenantLineHandler(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }

    public Expression getTenantId() {
        Long tenantId = TenantContextHolder.getTenantId();
        if (tenantId != null) {
            return new LongValue(tenantId.longValue());
        }
        log.warn("Tenant ID not found in current context.");
        return new NullValue();
    }

    public String getTenantIdColumn() {
        return this.tenantProperties.getTenantIdColumn();
    }

    public boolean ignoreTable(String tableName) {
        if (TenantContextHolder.isIgnore()) {
            return true;
        }
        if (TenantIsolationLevel.DATASOURCE.equals((Object)TenantContextHolder.getIsolationLevel())) {
            return true;
        }
        return CollUtil.contains((Collection)this.tenantProperties.getIgnoreTables(), (Object)tableName);
    }
}

