/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.messaging.websocket.core;

import cn.hutool.core.convert.Convert;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import top.continew.starter.messaging.websocket.autoconfigure.WebSocketProperties;
import top.continew.starter.messaging.websocket.dao.WebSocketSessionDao;

public class WebSocketHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    private final WebSocketProperties webSocketProperties;
    private final WebSocketSessionDao webSocketSessionDao;

    public WebSocketHandler(WebSocketProperties webSocketProperties, WebSocketSessionDao webSocketSessionDao) {
        this.webSocketProperties = webSocketProperties;
        this.webSocketSessionDao = webSocketSessionDao;
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        String clientId = this.getClientId(session);
        log.info("WebSocket receive message. clientId: {}, message: {}.", (Object)clientId, message.getPayload());
        super.handleTextMessage(session, message);
    }

    public void afterConnectionEstablished(WebSocketSession session) {
        String clientId = this.getClientId(session);
        this.webSocketSessionDao.add(clientId, session);
        log.info("WebSocket client connect successfully. clientId: {}.", (Object)clientId);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        String clientId = this.getClientId(session);
        this.webSocketSessionDao.delete(clientId);
        log.info("WebSocket client connect closed. clientId: {}.", (Object)clientId);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws IOException {
        String clientId = this.getClientId(session);
        if (session.isOpen()) {
            session.close();
        }
        this.webSocketSessionDao.delete(clientId);
    }

    private String getClientId(WebSocketSession session) {
        return Convert.toStr(session.getAttributes().get(this.webSocketProperties.getClientIdKey()));
    }
}

