/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.messaging.websocket.core;

import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;
import top.continew.starter.messaging.websocket.autoconfigure.WebSocketProperties;
import top.continew.starter.messaging.websocket.core.WebSocketClientService;

public class WebSocketInterceptor
extends HttpSessionHandshakeInterceptor {
    private final WebSocketProperties webSocketProperties;
    private final WebSocketClientService webSocketClientService;

    public WebSocketInterceptor(WebSocketProperties webSocketProperties, WebSocketClientService webSocketClientService) {
        this.webSocketProperties = webSocketProperties;
        this.webSocketClientService = webSocketClientService;
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        String clientId = this.webSocketClientService.getClientId((ServletServerHttpRequest)request);
        attributes.put(this.webSocketProperties.getClientIdKey(), clientId);
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
        super.afterHandshake(request, response, wsHandler, exception);
    }
}

