/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.ratelimiter.autoconfigure;

import jakarta.annotation.PostConstruct;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import top.continew.starter.cache.redisson.autoconfigure.RedissonAutoConfiguration;
import top.continew.starter.ratelimiter.aop.RateLimiterAspect;
import top.continew.starter.ratelimiter.autoconfigure.RateLimiterProperties;
import top.continew.starter.ratelimiter.generator.DefaultRateLimiterNameGenerator;
import top.continew.starter.ratelimiter.generator.RateLimiterNameGenerator;

@AutoConfiguration(after={RedissonAutoConfiguration.class})
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@ConditionalOnProperty(prefix="continew-starter.rate-limiter", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class RateLimiterAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RateLimiterAutoConfiguration.class);

    @Bean
    public RateLimiterAspect rateLimiterAspect(RateLimiterProperties properties, RateLimiterNameGenerator rateLimiterNameGenerator, RedissonClient redissonClient) {
        return new RateLimiterAspect(properties, rateLimiterNameGenerator, redissonClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public RateLimiterNameGenerator nameGenerator() {
        return new DefaultRateLimiterNameGenerator();
    }

    @PostConstruct
    public void postConstruct() {
        log.debug("[ContiNew Starter] - Auto Configuration 'RateLimiter' completed initialization.");
    }
}

