/*
 * Decompiled with CFR 0.152.
 */
package top.continew.starter.ratelimiter.generator;

import cn.hutool.core.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import top.continew.starter.ratelimiter.generator.RateLimiterNameGenerator;

public class DefaultRateLimiterNameGenerator
implements RateLimiterNameGenerator {
    protected final ConcurrentHashMap<Method, String> nameMap = new ConcurrentHashMap();

    @Override
    public String generate(Object target, Method method, Object ... args) {
        return this.nameMap.computeIfAbsent(method, key -> {
            StringBuilder nameSb = new StringBuilder();
            String className = method.getDeclaringClass().getName();
            nameSb.append(ClassUtil.getShortClassName((String)className));
            nameSb.append(".");
            nameSb.append(method.getName());
            nameSb.append("(");
            for (Class<?> clazz : method.getParameterTypes()) {
                this.getDescriptor(nameSb, clazz);
            }
            nameSb.append(")");
            return nameSb.toString();
        });
    }

    private void getDescriptor(StringBuilder sb, Class<?> typeClass) {
        Class<?> clazz = typeClass;
        while (true) {
            if (clazz.isPrimitive()) {
                sb.append(this.getPrimitiveChar(clazz));
                return;
            }
            if (!clazz.isArray()) break;
            sb.append("[");
            clazz = clazz.getComponentType();
        }
        sb.append('L');
        String name = clazz.getName();
        name = ClassUtil.getShortClassName((String)name);
        sb.append(name);
        sb.append(";");
    }

    private char getPrimitiveChar(Class<?> clazz) {
        int c = clazz == Integer.TYPE ? 73 : (clazz == Void.TYPE ? 86 : (clazz == Boolean.TYPE ? 90 : (clazz == Byte.TYPE ? 66 : (clazz == Character.TYPE ? 67 : (clazz == Short.TYPE ? 83 : (clazz == Double.TYPE ? 68 : (clazz == Float.TYPE ? 70 : 74)))))));
        return (char)c;
    }
}

