/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.utils.Experimental;

@Experimental
public class SmartContentSelector
implements Selector {
    private int threshold = 86;

    public SmartContentSelector() {
    }

    public SmartContentSelector(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public String select(String html) {
        html = html.replaceAll("(?is)<!DOCTYPE.*?>", "");
        html = html.replaceAll("(?is)<!--.*?-->", "");
        html = html.replaceAll("(?is)<script.*?>.*?</script>", "");
        html = html.replaceAll("(?is)<style.*?>.*?</style>", "");
        html = html.replaceAll("&.{2,5};|&#.{2,5};", " ");
        html = html.replaceAll("(?is)<.*?>", "");
        int blocksWidth = 3;
        StringBuilder text = new StringBuilder();
        ArrayList<Integer> indexDistribution = new ArrayList<Integer>();
        List<String> lines = Arrays.asList(html.split("\n"));
        int i = 0;
        while (i < lines.size() - blocksWidth) {
            int wordsNum = 0;
            int j = i;
            while (j < i + blocksWidth) {
                lines.set(j, lines.get(j).replaceAll("\\s+", ""));
                wordsNum += lines.get(j).length();
                ++j;
            }
            indexDistribution.add(wordsNum);
            ++i;
        }
        int start = -1;
        int end = -1;
        boolean boolstart = false;
        boolean boolend = false;
        text.setLength(0);
        int i2 = 0;
        while (i2 < indexDistribution.size() - 1) {
            if (!((Integer)indexDistribution.get(i2) <= this.threshold || boolstart || (Integer)indexDistribution.get(i2 + 1) == 0 && (Integer)indexDistribution.get(i2 + 2) == 0 && (Integer)indexDistribution.get(i2 + 3) == 0)) {
                boolstart = true;
                start = i2;
            } else {
                if (boolstart && ((Integer)indexDistribution.get(i2) == 0 || (Integer)indexDistribution.get(i2 + 1) == 0)) {
                    end = i2;
                    boolend = true;
                }
                StringBuilder tmp = new StringBuilder();
                if (boolend) {
                    int ii = start;
                    while (ii <= end) {
                        if (lines.get(ii).length() >= 5) {
                            tmp.append(lines.get(ii) + "\n");
                        }
                        ++ii;
                    }
                    String str = tmp.toString();
                    if (!str.contains("Copyright")) {
                        text.append(str);
                        boolend = false;
                        boolstart = false;
                    }
                }
            }
            ++i2;
        }
        return text.toString();
    }

    @Override
    public List<String> selectList(String text) {
        throw new UnsupportedOperationException();
    }
}

