/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.model.AfterExtractor;
import us.codecraft.webmagic.model.Extractor;
import us.codecraft.webmagic.model.FieldExtractor;
import us.codecraft.webmagic.model.annotation.ComboExtract;
import us.codecraft.webmagic.model.annotation.ExtractBy;
import us.codecraft.webmagic.model.annotation.ExtractByUrl;
import us.codecraft.webmagic.model.annotation.HelpUrl;
import us.codecraft.webmagic.model.annotation.TargetUrl;
import us.codecraft.webmagic.model.fields.PageField;
import us.codecraft.webmagic.model.formatter.ObjectFormatterBuilder;
import us.codecraft.webmagic.model.sources.Source;
import us.codecraft.webmagic.model.sources.SourceTextExtractor;
import us.codecraft.webmagic.selector.AndSelector;
import us.codecraft.webmagic.selector.OrSelector;
import us.codecraft.webmagic.selector.RegexSelector;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.XpathSelector;
import us.codecraft.webmagic.utils.ClassUtils;
import us.codecraft.webmagic.utils.ExtractorUtils;

class PageModelExtractor {
    private List<Pattern> targetUrlPatterns = new ArrayList<Pattern>();
    private Selector targetUrlRegionSelector;
    private List<Pattern> helpUrlPatterns = new ArrayList<Pattern>();
    private Selector helpUrlRegionSelector;
    private Class clazz;
    private List<FieldExtractor> fieldExtractors;
    private Extractor objectExtractor;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    PageModelExtractor() {
    }

    public static PageModelExtractor create(Class clazz) {
        PageModelExtractor pageModelExtractor = new PageModelExtractor();
        pageModelExtractor.init(clazz);
        return pageModelExtractor;
    }

    private void init(Class clazz) {
        this.clazz = clazz;
        this.initClassExtractors();
        this.fieldExtractors = new ArrayList<FieldExtractor>();
        for (Field field : ClassUtils.getFieldsIncludeSuperClass(clazz)) {
            field.setAccessible(true);
            FieldExtractor fieldExtractor = this.getAnnotationExtractBy(clazz, field);
            FieldExtractor fieldExtractorTmp = this.getAnnotationExtractCombo(clazz, field);
            if (fieldExtractor != null && fieldExtractorTmp != null) {
                throw new IllegalStateException("Only one of 'ExtractBy ComboExtract ExtractByUrl' can be added to a field!");
            }
            if (fieldExtractor == null && fieldExtractorTmp != null) {
                fieldExtractor = fieldExtractorTmp;
            }
            fieldExtractorTmp = this.getAnnotationExtractByUrl(clazz, field);
            if (fieldExtractor != null && fieldExtractorTmp != null) {
                throw new IllegalStateException("Only one of 'ExtractBy ComboExtract ExtractByUrl' can be added to a field!");
            }
            if (fieldExtractor == null && fieldExtractorTmp != null) {
                fieldExtractor = fieldExtractorTmp;
            }
            if (fieldExtractor == null) continue;
            fieldExtractor.setObjectFormatter(new ObjectFormatterBuilder().setField(field).build());
            this.fieldExtractors.add(fieldExtractor);
        }
    }

    private FieldExtractor getAnnotationExtractByUrl(Class clazz, Field field) {
        FieldExtractor fieldExtractor = null;
        ExtractByUrl extractByUrl = field.getAnnotation(ExtractByUrl.class);
        if (extractByUrl != null) {
            String regexPattern = extractByUrl.value();
            if (regexPattern.trim().equals("")) {
                regexPattern = ".*";
            }
            fieldExtractor = new FieldExtractor(field, (Selector)new RegexSelector(regexPattern), new Source.Url(), extractByUrl.notNull(), extractByUrl.multi() || List.class.isAssignableFrom(field.getType()));
            Method setterMethod = PageModelExtractor.getSetterMethod(clazz, field);
            if (setterMethod != null) {
                fieldExtractor.setSetterMethod(setterMethod);
            }
        }
        return fieldExtractor;
    }

    private FieldExtractor getAnnotationExtractCombo(Class clazz, Field field) {
        FieldExtractor fieldExtractor = null;
        ComboExtract comboExtract = field.getAnnotation(ComboExtract.class);
        if (comboExtract != null) {
            AndSelector selector;
            ExtractBy[] extractBies = comboExtract.value();
            switch (comboExtract.op()) {
                case And: {
                    selector = new AndSelector(ExtractorUtils.getSelectors(extractBies));
                    break;
                }
                case Or: {
                    selector = new OrSelector(ExtractorUtils.getSelectors(extractBies));
                    break;
                }
                default: {
                    selector = new AndSelector(ExtractorUtils.getSelectors(extractBies));
                }
            }
            fieldExtractor = new FieldExtractor(field, (Selector)selector, comboExtract.source() == ComboExtract.Source.RawHtml ? new Source.RawHtml() : new Source.SelectedHtml(), comboExtract.notNull(), comboExtract.multi() || List.class.isAssignableFrom(field.getType()));
            Method setterMethod = PageModelExtractor.getSetterMethod(clazz, field);
            if (setterMethod != null) {
                fieldExtractor.setSetterMethod(setterMethod);
            }
        }
        return fieldExtractor;
    }

    private FieldExtractor getAnnotationExtractBy(Class clazz, Field field) {
        FieldExtractor fieldExtractor = null;
        ExtractBy extractBy = field.getAnnotation(ExtractBy.class);
        if (extractBy != null) {
            Selector selector = ExtractorUtils.getSelector(extractBy);
            ExtractBy.Source extractSource = extractBy.source();
            if (extractBy.type() == ExtractBy.Type.JsonPath) {
                extractSource = ExtractBy.Source.RawText;
            }
            Source source = null;
            switch (extractSource) {
                case RawText: {
                    source = new Source.RawText();
                    break;
                }
                case RawHtml: {
                    source = new Source.RawHtml();
                    break;
                }
                case SelectedHtml: {
                    source = new Source.SelectedHtml();
                    break;
                }
                default: {
                    source = new Source.SelectedHtml();
                }
            }
            fieldExtractor = new FieldExtractor(field, selector, source, extractBy.notNull(), List.class.isAssignableFrom(field.getType()));
            fieldExtractor.setSetterMethod(PageModelExtractor.getSetterMethod(clazz, field));
        }
        return fieldExtractor;
    }

    public static Method getSetterMethod(Class clazz, Field field) {
        String name = "set" + StringUtils.capitalize((String)field.getName());
        try {
            Method declaredMethod = clazz.getDeclaredMethod(name, field.getType());
            declaredMethod.setAccessible(true);
            return declaredMethod;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void initClassExtractors() {
        String[] value;
        Annotation annotation = this.clazz.getAnnotation(TargetUrl.class);
        if (annotation == null) {
            this.targetUrlPatterns.add(Pattern.compile(".*"));
        } else {
            TargetUrl targetUrl = annotation;
            for (String s : value = targetUrl.value()) {
                this.targetUrlPatterns.add(Pattern.compile(s.replace(".", "\\.").replace("*", "[^\"'#]*")));
            }
            if (!targetUrl.sourceRegion().equals("")) {
                this.targetUrlRegionSelector = new XpathSelector(targetUrl.sourceRegion());
            }
        }
        annotation = this.clazz.getAnnotation(HelpUrl.class);
        if (annotation != null) {
            HelpUrl helpUrl = (HelpUrl)annotation;
            for (String s : value = helpUrl.value()) {
                this.helpUrlPatterns.add(Pattern.compile(s.replace(".", "\\.").replace("*", "[^\"'#]*")));
            }
            if (!helpUrl.sourceRegion().equals("")) {
                this.helpUrlRegionSelector = new XpathSelector(helpUrl.sourceRegion());
            }
        }
        if ((annotation = this.clazz.getAnnotation(ExtractBy.class)) != null) {
            ExtractBy extractBy = (ExtractBy)annotation;
            this.objectExtractor = new Extractor((Selector)new XpathSelector(extractBy.value()), new Source.SelectedHtml(), extractBy.notNull(), extractBy.multi());
        }
    }

    public Object process(Page page) {
        boolean matched = false;
        for (Pattern targetPattern : this.targetUrlPatterns) {
            if (!targetPattern.matcher(page.getUrl().toString()).matches()) continue;
            matched = true;
        }
        if (!matched) {
            return null;
        }
        if (this.objectExtractor == null) {
            return this.processSingle(page, null, true);
        }
        if (this.objectExtractor.multi) {
            ArrayList<Object> os = new ArrayList<Object>();
            List list = this.objectExtractor.getSelector().selectList(page.getRawText());
            for (String s : list) {
                Object o = this.processSingle(page, s, false);
                if (o == null) continue;
                os.add(o);
            }
            return os;
        }
        String select = this.objectExtractor.getSelector().select(page.getRawText());
        Object o = this.processSingle(page, select, false);
        return o;
    }

    private Object processSingle(Page page, String html, boolean isRaw) {
        Object o = null;
        try {
            o = this.clazz.newInstance();
            for (FieldExtractor fieldExtractor : this.fieldExtractors) {
                PageField field = SourceTextExtractor.getText(page, html, isRaw, fieldExtractor);
                if (field.operation(o, fieldExtractor, this.logger)) continue;
                return null;
            }
            if (AfterExtractor.class.isAssignableFrom(this.clazz)) {
                ((AfterExtractor)o).afterProcess(page);
            }
        }
        catch (Exception e) {
            this.logger.error("extract fail", (Throwable)e);
        }
        return o;
    }

    public List<Pattern> getTargetUrlPatterns() {
        return this.targetUrlPatterns;
    }

    public Selector getTargetUrlRegionSelector() {
        return this.targetUrlRegionSelector;
    }

    public List<Pattern> getHelpUrlPatterns() {
        return this.helpUrlPatterns;
    }

    public Selector getHelpUrlRegionSelector() {
        return this.helpUrlRegionSelector;
    }

    public Class getClazz() {
        return this.clazz;
    }
}

