/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.constant;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import xyz.erupt.annotation.fun.ChoiceFetchHandler;
import xyz.erupt.annotation.fun.VLModel;

public enum MenuTypeEnum {
    TABLE("table", "\u8868\u683c\u89c6\u56fe", "\u586berupt\u7c7b\u540d"),
    TREE("tree", "\u6811\u72b6\u89c6\u56fe", "\u586berupt\u7c7b\u540d"),
    BUTTON("button", "\u529f\u80fd\u6309\u94ae", null),
    API("api", "\u63a5\u53e3\u540d\u79f0", null),
    LINK("link", "\u6846\u67b6\u5185\u6253\u5f00\u94fe\u63a5", "\u4e92\u8054\u7f51\u5730\u5740"),
    NEW_WINDOW("newWindow", "\u65b0\u7a97\u53e3\u6253\u5f00\u94fe\u63a5", "\u4e92\u8054\u7f51\u5730\u5740"),
    THIS_WINDOW("selfWindow", "\u672c\u7a97\u53e3\u6253\u5f00\u94fe\u63a5", "\u4e92\u8054\u7f51\u5730\u5740"),
    FILL("fill", "\u5145\u6ee1\u5c4f\u5e55", "\u9700\u8981\u5145\u6ee1\u5c4f\u5e55\u7684\u8def\u7531\u5730\u5740"),
    ROUTER("router", "\u9875\u9762\u8def\u7531", "\u524d\u7aef\u5f00\u53d1\u65f6\u7684\u8def\u7531\u5730\u5740");

    private final String code;
    private final String name;
    private final String desc;
    private static final List<VLModel> menuTypes;

    private MenuTypeEnum(String code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public static void addMenuType(VLModel menuType) {
        menuTypes.add(menuType);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    static {
        menuTypes = Stream.of(MenuTypeEnum.values()).map(menuTypeEnum -> new VLModel(menuTypeEnum.getCode(), menuTypeEnum.getName(), menuTypeEnum.getDesc())).collect(Collectors.toList());
    }

    public static class ChoiceFetch
    implements ChoiceFetchHandler {
        public List<VLModel> fetch(String[] params) {
            return menuTypes.stream().map(it -> new VLModel(it.getValue(), it.getLabel(), it.getDesc())).collect(Collectors.toList());
        }
    }
}

