/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller;

import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import xyz.erupt.annotation.fun.AttachmentProxy;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.sub_edit.AttachmentType;
import xyz.erupt.annotation.sub_field.sub_edit.HtmlEditorType;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.EruptFileService;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptModel;

@RestController
@RequestMapping(value={"/erupt-api/file"})
public class EruptFileController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptFileController.class);
    private final EruptProp eruptProp;
    private final EruptFileService eruptFileService;
    private static final String FS_SEP = "/";
    private static final String DOWNLOAD_PATH = "/download-attachment";

    @PostMapping(value={"/upload/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel upload(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="file") MultipartFile file) {
        if (null == file.getOriginalFilename()) {
            return EruptApiModel.errorApi(I18nTranslate.$translate("filename is empty"));
        }
        EruptModel eruptModel = EruptCoreService.getErupt(eruptName);
        Erupts.powerLegal(eruptModel, powerObject -> powerObject.isEdit() || powerObject.isAdd());
        Edit edit = eruptModel.getEruptFieldMap().get(fieldName).getEruptField().edit();
        Object path = this.eruptFileService.createPath(file).replace(edit.attachmentType().fileSeparator(), "");
        switch (edit.type()) {
            case ATTACHMENT: {
                AttachmentType attachmentType = edit.attachmentType();
                if (attachmentType.fileTypes().length > 0) {
                    String[] fileNameArr = file.getOriginalFilename().split("\\.");
                    String extensionName = fileNameArr[fileNameArr.length - 1];
                    if (Stream.of(attachmentType.fileTypes()).noneMatch(type -> extensionName.equalsIgnoreCase((String)type))) {
                        return EruptApiModel.errorApi(I18nTranslate.$translate("erupt.upload_error.file_format") + ": " + extensionName);
                    }
                }
                if (!"".equals(attachmentType.path())) {
                    path = attachmentType.path() + (String)path;
                }
                if (attachmentType.size() > 0L && file.getSize() / 1024L > attachmentType.size()) {
                    return EruptApiModel.errorApi(I18nTranslate.$translate("erupt.upload_error.size") + ": " + attachmentType.size() + "KB");
                }
                switch (edit.attachmentType().type()) {
                    case IMAGE: {
                        AttachmentType.ImageType imageType = edit.attachmentType().imageType();
                        BufferedImage bufferedImage = ImageIO.read(file.getInputStream());
                        if (bufferedImage == null) {
                            return EruptApiModel.errorApi(I18nTranslate.$translate("erupt.upload_error.not_image"));
                        }
                        int width = bufferedImage.getWidth();
                        int height = bufferedImage.getHeight();
                        if (imageType.minWidth() > width || imageType.maxWidth() < width) {
                            return EruptApiModel.errorApi(I18nTranslate.$translate("erupt.upload_error.image_width") + String.format("[%s,%s]", imageType.minWidth(), imageType.maxWidth()));
                        }
                        if (imageType.minHeight() <= height && imageType.maxHeight() >= height) break;
                        return EruptApiModel.errorApi(I18nTranslate.$translate("erupt.upload_error.image_height") + String.format("[%s,%s]", imageType.minWidth(), imageType.maxWidth()));
                    }
                }
                break;
            }
            case HTML_EDITOR: {
                HtmlEditorType htmlEditorType = edit.htmlEditorType();
                if ("".equals(htmlEditorType.path())) break;
                path = htmlEditorType.path() + (String)path;
            }
        }
        return EruptApiModel.successApi(this.eruptFileService.upload(file, (String)path));
    }

    @PostMapping(value={"/uploads/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT)
    public EruptApiModel uploads(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="file") MultipartFile[] files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (MultipartFile file : files) {
            EruptApiModel eruptApiModel = this.upload(eruptName, fieldName, file);
            paths.add(eruptApiModel.getData().toString());
        }
        return EruptApiModel.successApi(paths);
    }

    @PostMapping(value={"/upload-html-editor/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyMethod=EruptRouter.VerifyMethod.PARAM, verifyType=EruptRouter.VerifyType.ERUPT)
    public Map<String, Object> uploadHtmlEditorImage(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="upload") MultipartFile file) throws ClassNotFoundException {
        EruptApiModel eruptApiModel = this.upload(eruptName, fieldName, file);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (eruptApiModel.getStatus() == EruptApiModel.Status.SUCCESS) {
            AttachmentProxy attachmentProxy = EruptUtil.findAttachmentProxy();
            if (null != attachmentProxy) {
                map.put("url", attachmentProxy.fileDomain() + eruptApiModel.getData());
            } else {
                map.put("url", "/erupt-attachment" + eruptApiModel.getData());
            }
        } else {
            map.put("uploaded", false);
            map.put("state", "ERROR");
            throw new EruptWebApiRuntimeException(eruptApiModel.getMessage());
        }
        map.put("uploaded", true);
        map.put("state", "SUCCESS");
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload-ueditor/{erupt}/{field}"})
    @EruptRouter(authIndex=2, verifyMethod=EruptRouter.VerifyMethod.PARAM, verifyType=EruptRouter.VerifyType.ERUPT)
    public void uploadUEditorImage(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String fieldName, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="file", required=false) MultipartFile file, HttpServletResponse response) throws IOException, ClassNotFoundException {
        if (null == file) {
            InputStream stream = EruptFileController.class.getClassLoader().getResourceAsStream("ueditor.json");
            try {
                String json = StreamUtils.copyToString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                if (null == callback) {
                    response.getOutputStream().write(json.getBytes(StandardCharsets.UTF_8));
                }
                response.getOutputStream().write((callback + "(" + json + ")").getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        } else {
            Map<String, Object> map = this.uploadHtmlEditorImage(eruptName, fieldName, file);
            map.put("filename", file.getName());
            map.put("original", file.getOriginalFilename());
            map.put("name", file.getName());
            map.put("size", file.getSize());
            response.getOutputStream().write(new Gson().toJson(map).getBytes(StandardCharsets.UTF_8));
        }
    }

    @GetMapping(value={"/download-attachment/**"}, produces={"application/octet-stream"})
    public void downloadAttachment(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Path uploadRoot;
        Path target;
        Object path = request.getServletPath().replace("/erupt-api/file/download-attachment", "");
        if (!((String)path).startsWith(FS_SEP)) {
            path = FS_SEP + (String)path;
        }
        if (!(target = (uploadRoot = Paths.get(this.eruptProp.getUploadPath(), new String[0])).resolve(((String)path).substring(1)).normalize()).startsWith(uploadRoot)) {
            response.sendError(400, "Illegal path");
            return;
        }
        if (!Files.isRegularFile(target, new LinkOption[0]) || !Files.exists(target, new LinkOption[0])) {
            response.sendError(HttpStatus.NOT_FOUND.value());
            return;
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + target.getFileName() + "\"");
        Files.copy(target, (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }

    @Generated
    public EruptFileController(EruptProp eruptProp, EruptFileService eruptFileService) {
        this.eruptProp = eruptProp;
        this.eruptFileService = eruptFileService;
    }
}

