/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.controller.advice;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.core.view.EruptExceptionVo;

@Order(value=0x7FFFFFFE)
@ControllerAdvice(value={"xyz.erupt"})
public class EruptExceptionAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EruptExceptionAdvice.class);
    private static final String ERE = "erupt exception";

    @ExceptionHandler(value={EruptApiErrorTip.class})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public EruptApiModel eruptApiErrorTip(EruptApiErrorTip e) {
        log.error(ERE, (Throwable)e);
        return e.eruptApiModel;
    }

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public EruptExceptionVo eruptException(Exception e, HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        log.error(ERE, (Throwable)e);
        return new EruptExceptionVo(request.getServletPath(), response.getStatus(), ERE, e instanceof RuntimeException ? e.getMessage() : null);
    }
}

