/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.i18n;

import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.erupt.core.i18n.I18nRunner;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.util.EruptSpringUtil;

@Service
public class I18nTranslate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(I18nTranslate.class);
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptProp eruptProp;
    private static final I18nRunner i18nRunner = new I18nRunner();

    public static String $translate(String key) {
        return EruptSpringUtil.getBean(I18nTranslate.class).translate(key);
    }

    public String translate(String key) {
        String lang = this.getLang();
        return this.translate(lang == null ? this.eruptProp.getDefaultLocales() : lang, key);
    }

    public String translate(String lang, String key) {
        return I18nRunner.getI18nValue(lang, key);
    }

    public String getLang() {
        try {
            String lang = this.request.getHeader("Lang");
            if (I18nRunner.langs().contains(lang)) {
                return lang;
            }
            log.warn("Error: Invalid lang: {}", (Object)lang);
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    static {
        i18nRunner.init();
    }
}

