/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import xyz.erupt.core.operator.OperatorExpr;
import xyz.erupt.core.operator.OperatorStringType;
import xyz.erupt.core.util.TypeUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OperatorDateType implements OperatorExpr
{
    TODAY{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            return FUTURE_DAYS.expr(field, 0, parameter);
        }
    }
    ,
    FEW_DAYS{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            int days = TypeUtil.fetchInt(value);
            String placeholder1 = this.placeholder();
            parameter.put(placeholder1, LocalDate.now().minusDays(days).atStartOfDay().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            String placeholder2 = this.placeholder();
            parameter.put(placeholder2, LocalDate.now().atStartOfDay().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            return String.format("%s between :%s and :%s", field, placeholder1, placeholder2);
        }
    }
    ,
    FUTURE_DAYS{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            int days = TypeUtil.fetchInt(value);
            String placeholder1 = this.placeholder();
            parameter.put(placeholder1, LocalDate.now().plusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            String placeholder2 = this.placeholder();
            parameter.put(placeholder2, LocalDate.now().plusDays(days).atTime(LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            return String.format("%s between :%s and :%s", field, placeholder1, placeholder2);
        }
    }
    ,
    RANGE{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            ArrayList s = (ArrayList)value;
            String placeholder1 = this.placeholder();
            parameter.put(placeholder1, s.get(0));
            String placeholder2 = this.placeholder();
            parameter.put(placeholder2, s.get(1) + OperatorDateType.TIME_END);
            return String.format("%s between :%s and :%s", field, placeholder1, placeholder2);
        }
    }
    ,
    GT{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, OperatorDateType.parseDate(value.toString()));
            return String.format("%s > :%s", field, placeholder);
        }
    }
    ,
    LT{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, OperatorDateType.parseDate(value.toString()) + OperatorDateType.TIME_END);
            return String.format("%s < :%s", field, placeholder);
        }
    }
    ,
    EGT{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, OperatorDateType.parseDate(value.toString()));
            return String.format("%s >= :%s", field, placeholder);
        }
    }
    ,
    ELT{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, OperatorDateType.parseDate(value.toString()) + OperatorDateType.TIME_END);
            return String.format("%s <= :%s", field, placeholder);
        }
    }
    ,
    NULL{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            return OperatorStringType.NULL.expr(field, value, null);
        }
    }
    ,
    NOT_NULL{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            return OperatorStringType.NOT_NULL.expr(field, value, null);
        }
    };

    public static final String TIME_END = " 23:59:59.999999999";

    public static String parseDate(String date) {
        return date;
    }

    @Generated
    private OperatorDateType() {
    }
}

