/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.operator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import xyz.erupt.core.operator.OperatorExpr;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OperatorStringType implements OperatorExpr
{
    EQ{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, value);
            return String.format("%s = :%s", field, placeholder);
        }
    }
    ,
    NEQ{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, value);
            return String.format("%s != :%s", field, placeholder);
        }
    }
    ,
    LIKE{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, "%" + value + "%");
            return String.format("%s like :%s", field, placeholder);
        }
    }
    ,
    NOT_LIKE{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, "%" + value + "%");
            return String.format("%s not like :%s", field, placeholder);
        }
    }
    ,
    START_WITH{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, value + "%");
            return String.format("%s like :%s", field, placeholder);
        }
    }
    ,
    END_WITH{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            String placeholder = this.placeholder();
            parameter.put(placeholder, "%" + value);
            return String.format("%s like :%s", field, placeholder);
        }
    }
    ,
    IN{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            Collection collection = (Collection)value;
            ArrayList<CallSite> conditions = new ArrayList<CallSite>();
            for (Object object : collection) {
                String placeholder = this.placeholder();
                parameter.put(placeholder, "%" + object + "%");
                conditions.add((CallSite)((Object)(field + " like :" + placeholder)));
            }
            return "(" + String.join((CharSequence)" or ", conditions) + ")";
        }
    }
    ,
    NOT_IN{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            Collection collection = (Collection)value;
            ArrayList<CallSite> conditions = new ArrayList<CallSite>();
            for (Object object : collection) {
                String placeholder = this.placeholder();
                parameter.put(placeholder, "%" + object + "%");
                conditions.add((CallSite)((Object)(field + " not like :" + placeholder)));
            }
            return "(" + String.join((CharSequence)" and ", conditions) + ")";
        }
    }
    ,
    NULL{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            return String.format("%s is null", field);
        }
    }
    ,
    NOT_NULL{

        @Override
        public String expr(String field, Object value, Map<String, Object> parameter) {
            return String.format("%s is not null", field);
        }
    };


    @Generated
    private OperatorStringType() {
    }
}

