/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.proxy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import xyz.erupt.annotation.config.EruptProperty;
import xyz.erupt.annotation.config.Match;
import xyz.erupt.annotation.config.ToMap;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.EditTypeMapping;
import xyz.erupt.annotation.sub_field.EditTypeSearch;
import xyz.erupt.core.util.TypeUtil;

public class AnnotationProcess {
    private static final String[] ANNOTATION_NUMBER_TYPE = new String[]{"short", "int", "long", "float", "double"};
    private static final String[] ANNOTATION_STRING_TYPE = new String[]{"String", "byte", "char"};
    private static final String EMPTY_ARRAY = "[]";
    private static final String VALUE_VAR = "value";
    private static final String ITEM_VAR = "item";
    private static final ExpressionParser parser = new SpelExpressionParser();

    public static JsonObject annotationToJsonByReflect(Annotation annotation) {
        JsonObject jsonObject = new JsonObject();
        for (Method method : annotation.annotationType().getDeclaredMethods()) {
            Transient tran = method.getAnnotation(Transient.class);
            if (null != tran && tran.value()) continue;
            String methodName = method.getName();
            EruptProperty eruptProperty = method.getAnnotation(EruptProperty.class);
            if (null != eruptProperty && !"".equals(eruptProperty.alias())) {
                methodName = eruptProperty.alias();
            }
            String returnType = method.getReturnType().getSimpleName();
            Object result = method.invoke((Object)annotation, new Object[0]);
            Match match = method.getAnnotation(Match.class);
            if (null != match) {
                StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
                evaluationContext.setVariable(VALUE_VAR, result);
                evaluationContext.setVariable(ITEM_VAR, (Object)annotation);
                Object r = parser.parseExpression(match.value()).getValue((EvaluationContext)evaluationContext);
                if (null == r || !((Boolean)r).booleanValue()) continue;
            }
            if (returnType.endsWith(EMPTY_ARRAY)) {
                returnType = returnType.substring(0, returnType.length() - 2);
                JsonArray jsonArray = new JsonArray();
                ToMap toMap = method.getAnnotation(ToMap.class);
                JsonObject jsonMap = new JsonObject();
                if (Arrays.asList(ANNOTATION_NUMBER_TYPE).contains(returnType)) {
                    TypeUtil.simpleNumberTypeArrayToObject(result, returnType, arg_0 -> ((JsonArray)jsonArray).add(arg_0));
                } else {
                    for (Object res : (Object[])result) {
                        if (String.class.getSimpleName().equals(returnType)) {
                            jsonArray.add(res.toString());
                            continue;
                        }
                        if (Character.TYPE.getSimpleName().equals(returnType)) {
                            jsonArray.add((Character)res);
                            continue;
                        }
                        if (Byte.TYPE.getSimpleName().equals(returnType)) {
                            jsonArray.add((Character)res);
                            continue;
                        }
                        if (Boolean.TYPE.getSimpleName().equals(returnType)) {
                            jsonArray.add((Boolean)res);
                            continue;
                        }
                        if (Class.class.getSimpleName().equals(returnType)) {
                            jsonArray.add(((Class)res).getSimpleName());
                            continue;
                        }
                        if (res.getClass().isEnum()) {
                            jsonArray.add(res.toString());
                            continue;
                        }
                        Annotation ann = (Annotation)res;
                        if (null != toMap) {
                            JsonObject jo = AnnotationProcess.annotationToJsonByReflect((Annotation)res);
                            String key = ann.annotationType().getMethod(toMap.key(), new Class[0]).invoke(res, new Object[0]).toString();
                            jo.remove(toMap.key());
                            jsonMap.add(key, (JsonElement)jo);
                            continue;
                        }
                        jsonArray.add((JsonElement)AnnotationProcess.annotationToJsonByReflect(ann));
                    }
                }
                if (null == toMap) {
                    jsonObject.add(methodName, (JsonElement)jsonArray);
                    continue;
                }
                if (jsonMap.isEmpty()) continue;
                jsonObject.add(methodName, (JsonElement)jsonMap);
                continue;
            }
            if (Arrays.asList(ANNOTATION_STRING_TYPE).contains(returnType)) {
                jsonObject.addProperty(methodName, result.toString());
                continue;
            }
            if (Arrays.asList(ANNOTATION_NUMBER_TYPE).contains(returnType)) {
                jsonObject.addProperty(methodName, (Number)result);
                continue;
            }
            if (Boolean.TYPE.getSimpleName().equals(returnType)) {
                jsonObject.addProperty(methodName, (Boolean)result);
                continue;
            }
            if (method.getReturnType().isEnum()) {
                jsonObject.addProperty(methodName, result.toString());
                continue;
            }
            if (method.getReturnType().isAnnotation()) {
                jsonObject.add(methodName, (JsonElement)AnnotationProcess.annotationToJsonByReflect((Annotation)result));
                continue;
            }
            if (!Class.class.getSimpleName().equals(returnType)) continue;
            jsonObject.addProperty(methodName, ((Class)result).getSimpleName());
        }
        return jsonObject;
    }

    @Deprecated
    public static String annotationToJsonByReplace(String annotationStr) throws JSONException {
        String convertStr = annotationStr.replaceAll("@xyz\\.erupt\\.annotation\\.sub_field\\.sub_edit\\.sub_attachment\\.\\w+", "").replaceAll("@xyz\\.erupt\\.annotation\\.sub_field\\.sub_edit\\.\\w+", "").replaceAll("@xyz\\.erupt\\.annotation\\.sub_field\\.sub_view\\.\\w+", "").replaceAll("@xyz\\.erupt\\.annotation\\.sub_field\\.\\w+", "").replaceAll("@xyz\\.erupt\\.annotation\\.sub_erupt\\.\\w+", "").replaceAll("@xyz\\.erupt\\.annotation\\.\\w+", "").replaceAll("class [a-zA-Z0-9.]+", "").replace("=,", "='',").replace("=)", "='')").replace("=", ":").replace("(", "{").replace(")", "}");
        return new JSONObject(convertStr).toString();
    }

    public static EditTypeMapping getEditTypeMapping(EditType editType) {
        return EditType.class.getDeclaredField(editType.name()).getAnnotation(EditTypeMapping.class);
    }

    public static EditTypeSearch getEditTypeSearch(EditType editType) {
        return EditType.class.getDeclaredField(editType.name()).getAnnotation(EditTypeSearch.class);
    }
}

