/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.proxy;

import java.lang.reflect.Field;
import lombok.Generated;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.util.EruptSpringUtil;

public class ProxyContext {
    private static final ThreadLocal<ProxyContext> proxyContextThreadLocal = ThreadLocal.withInitial(ProxyContext::new);
    private Class<?> clazz;
    private Field field;
    private boolean i18n = false;
    private boolean starting = false;

    public static void set(Class<?> clazz) {
        proxyContextThreadLocal.get().setClazz(clazz);
        proxyContextThreadLocal.get().setI18n(null != clazz.getAnnotation(EruptI18n.class));
    }

    public static void set(Field field, boolean starting) {
        proxyContextThreadLocal.get().setField(field);
        proxyContextThreadLocal.get().setStarting(starting);
        ProxyContext.set(field.getDeclaringClass());
    }

    public static ProxyContext get() {
        return proxyContextThreadLocal.get();
    }

    public static void remove() {
        proxyContextThreadLocal.remove();
    }

    public static String translate(String key) {
        if (ProxyContext.get().i18n) {
            return EruptSpringUtil.getBean(I18nTranslate.class).translate(key);
        }
        return key;
    }

    @Generated
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Generated
    public Field getField() {
        return this.field;
    }

    @Generated
    public boolean isI18n() {
        return this.i18n;
    }

    @Generated
    public boolean isStarting() {
        return this.starting;
    }

    @Generated
    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Generated
    public void setField(Field field) {
        this.field = field;
    }

    @Generated
    public void setI18n(boolean i18n) {
        this.i18n = i18n;
    }

    @Generated
    public void setStarting(boolean starting) {
        this.starting = starting;
    }
}

