/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;

public class SecurityUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityUtil.class);
    private static final Pattern XSS_PATTERN = Pattern.compile("<script\\b[^>]*>(.*?)</script>|\\b(?:onclick|onload|onmouseover|onfocus|onerror|onchange|onsubmit|onkeydown|onkeyup|onblur|onresize|onscroll|ondblclick|onmousedown|onmouseup|onmousemove|onmouseout|oninput|onpaste|oncut|oncopy|ondrag|ondrop|onreset|onselect|onwheel)\\s*\\s*=\\b(?:javascript|vbscript|data):|\\b(?:src|href|action)\\s*\\s*=\\s*(['\"]?)\\s*(?:javascript|vbscript|data):|\\b(?:eval|expression|setTimeout|setInterval|Function|alert|confirm|prompt)\\s*\\s*\\(|<(?:iframe|object|embed|applet)\\b[^>]*>|\\bexpression\\s*\\s*\\(|\\b(?:innerHTML|outerHTML|document\\.write|document\\.writeln)\\s*\\s*=", 42);

    public static boolean xssInspect(String value) {
        return value != null && XSS_PATTERN.matcher(value).find();
    }

    public static boolean csrfInspect(HttpServletRequest request, HttpServletResponse response) {
        String origin = request.getHeader("Origin");
        if (null != origin && !origin.contains(request.getHeader("Host"))) {
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("text/plain; charset=utf-8");
            try {
                PrintWriter out = response.getWriter();
                try {
                    String text = "Illegal cross-site request!";
                    out.append(text);
                    throw new EruptWebApiRuntimeException(text);
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.error("csrf inspect error", (Throwable)e);
                return true;
            }
        }
        return false;
    }
}

