/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.core.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.math.NumberUtils;

public class TypeUtil {
    private static final String[] SIMPLE_JPA_TYPE = new String[]{"byte", "short", "int", "integer", "long", "float", "double", "boolean", "char", "String", "date", "character", "char"};
    private static final String[] NUMBER_TYPE = new String[]{"short", "int", "integer", "long", "float", "double", "bigdecimal", "biginteger"};

    public static Object typeStrConvertObject(Object obj, Class<?> targetType) {
        String val;
        String str = val = obj.toString();
        if (NumberUtils.isCreatable((String)val) && val.endsWith(".0")) {
            val = val.substring(0, val.length() - 2);
        }
        if (Integer.TYPE == targetType || Integer.class == targetType) {
            return Integer.valueOf(val);
        }
        if (Short.TYPE == targetType || Short.class == targetType) {
            return Short.valueOf(val);
        }
        if (Long.TYPE == targetType || Long.class == targetType) {
            return Long.valueOf(val);
        }
        if (Float.TYPE == targetType || Float.class == targetType) {
            return Float.valueOf(val);
        }
        if (Double.TYPE == targetType || Double.class == targetType) {
            return Double.valueOf(val);
        }
        if (BigDecimal.class == targetType) {
            return new BigDecimal(val);
        }
        if (Boolean.TYPE == targetType || Boolean.class == targetType) {
            return Boolean.valueOf(val);
        }
        if (targetType.isEnum()) {
            return targetType.getMethod("valueOf", String.class).invoke(targetType, val);
        }
        return str;
    }

    public static void simpleNumberTypeArrayToObject(Object obj, String type, Consumer<Number> consumer) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!Integer.TYPE.getSimpleName().equals(type)) break block5;
                            int[] nArray = (int[])obj;
                            int n = nArray.length;
                            for (int i = 0; i < n; ++i) {
                                Integer i2 = nArray[i];
                                consumer.accept(i2);
                            }
                            break block6;
                        }
                        if (!Short.TYPE.getSimpleName().equals(type)) break block7;
                        short[] sArray = (short[])obj;
                        int n = sArray.length;
                        for (int i = 0; i < n; ++i) {
                            Short i3 = sArray[i];
                            consumer.accept(i3);
                        }
                        break block6;
                    }
                    if (!Long.TYPE.getSimpleName().equals(type)) break block8;
                    long[] lArray = (long[])obj;
                    int n = lArray.length;
                    for (int i = 0; i < n; ++i) {
                        Long i4 = lArray[i];
                        consumer.accept(i4);
                    }
                    break block6;
                }
                if (!Float.TYPE.getSimpleName().equals(type)) break block9;
                float[] fArray = (float[])obj;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    Float i5 = Float.valueOf(fArray[i]);
                    consumer.accept(i5);
                }
                break block6;
            }
            if (!Double.TYPE.getSimpleName().equals(type)) break block6;
            double[] dArray = (double[])obj;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double i6 = dArray[i];
                consumer.accept(i6);
            }
        }
    }

    public static boolean isFieldSimpleType(String typeName) {
        return Arrays.asList(SIMPLE_JPA_TYPE).contains(typeName.toLowerCase());
    }

    public static boolean isNumberType(String typeName) {
        return Arrays.asList(NUMBER_TYPE).contains(typeName.toLowerCase());
    }

    public static boolean isNumber(Object obj) {
        return obj instanceof Number || NumberUtils.isCreatable((String)obj.toString());
    }

    public static Integer fetchInt(Object value) {
        if (value instanceof String) {
            return Integer.parseInt(value.toString());
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return ((Double)value).intValue();
    }

    public static String arrayToConditonString(List<Object> objects, Class<?> target) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object o : objects) {
            Object val = TypeUtil.typeStrConvertObject(o, target);
            if (val instanceof String) {
                val = "'" + val + "'";
            }
            values.add(val.toString());
        }
        return String.join((CharSequence)",", values);
    }
}

